/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.ParserType;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;

public class TestHeaderOverflowError {
    public static void test(ParserType parserType) {
        HTTPParser hTTPParser = new HTTPParser(parserType);
        ByteBuffer byteBuffer = TestHeaderOverflowError.getBytes(parserType);
        int n = byteBuffer.limit();
        hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
        Util.check(n == byteBuffer.position());
        byteBuffer = Util.buffer("header-key: header-value\r\n");
        n = byteBuffer.limit();
        for (int i = 0; i != 1000; ++i) {
            hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
            Util.check(n == byteBuffer.position());
            byteBuffer.rewind();
        }
    }

    static ByteBuffer getBytes(ParserType parserType) {
        if (ParserType.HTTP_BOTH == parserType) {
            throw new RuntimeException("only HTTP_REQUEST and HTTP_RESPONSE");
        }
        if (ParserType.HTTP_REQUEST == parserType) {
            return Util.buffer("GET / HTTP/1.1\r\n");
        }
        return Util.buffer("HTTP/1.0 200 OK\r\n");
    }

    public static void test() {
        Util.p(TestHeaderOverflowError.class);
        TestHeaderOverflowError.test(ParserType.HTTP_REQUEST);
        TestHeaderOverflowError.test(ParserType.HTTP_RESPONSE);
    }
}

