/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserAggregateDefinition;
import org.apache.derby.impl.sql.compile.ValueNode;

class AggregateNode
extends UnaryOperatorNode {
    private static BuiltinAggDescriptor[] BUILTIN_MODERN_AGGS = new BuiltinAggDescriptor[]{new BuiltinAggDescriptor("VAR_POP", "org.apache.derby.impl.sql.execute.VarPAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("VAR_SAMP", "org.apache.derby.impl.sql.execute.VarSAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("STDDEV_POP", "org.apache.derby.impl.sql.execute.StdDevPAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE), new BuiltinAggDescriptor("STDDEV_SAMP", "org.apache.derby.impl.sql.execute.StdDevSAggregator", TypeDescriptor.DOUBLE, TypeDescriptor.DOUBLE)};
    private boolean distinct;
    private AggregateDefinition uad;
    private TableName userAggregateName;
    private StringBuffer aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class<?> aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    AggregateNode(ValueNode valueNode, UserAggregateDefinition userAggregateDefinition, TableName tableName, boolean bl, String string, ContextManager contextManager) throws StandardException {
        this(valueNode, tableName, bl, string, contextManager);
        this.setUserDefinedAggregate(userAggregateDefinition);
    }

    AggregateNode(ValueNode valueNode, TableName tableName, boolean bl, String string, ContextManager contextManager) throws StandardException {
        super(valueNode, contextManager);
        this.aggregateName = string;
        this.userAggregateName = tableName;
        this.distinct = bl;
    }

    AggregateNode(ValueNode valueNode, Class<?> clazz, boolean bl, String string, ContextManager contextManager) throws StandardException {
        super(valueNode, contextManager);
        this.aggregateName = string;
        this.aggregateDefinitionClass = clazz;
        if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
            this.distinct = bl;
        }
        this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
    }

    private void setUserDefinedAggregate(UserAggregateDefinition userAggregateDefinition) {
        this.uad = userAggregateDefinition;
        this.aggregateDefinitionClass = this.uad.getClass();
        this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
    }

    ValueNode replaceAggregatesWithColumnReferences(ResultColumnList resultColumnList, int n) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext compilerContext = this.getCompilerContext();
            String string = "SQLCol" + compilerContext.getNextColumnNumber();
            this.generatedRC = new ResultColumn(string, (ValueNode)this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = new ColumnReference(this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (n != -1) {
                this.generatedRef.setTableNumber(n);
            }
            resultColumnList.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            resultColumnList.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    ResultColumn getGeneratedRC() {
        return this.generatedRC;
    }

    ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        DataDictionary dataDictionary = this.getDataDictionary();
        DataTypeDescriptor dataTypeDescriptor = null;
        ClassFactory classFactory = this.getClassFactory();
        this.classInspector = classFactory.getClassInspector();
        boolean bl = true;
        if (this.userAggregateName != null) {
            bl = this.userAggregateName.getSchemaName() == null;
            this.userAggregateName.bind();
        }
        if (this.userAggregateName != null && this.uad == null) {
            object3 = this.userAggregateName.getSchemaName();
            object2 = AggregateNode.resolveAggregate(dataDictionary, this.getSchemaDescriptor((String)object3, true), this.userAggregateName.getTableName(), bl);
            if (object2 == null) {
                throw StandardException.newException("42X94", AliasDescriptor.getAliasType('G'), this.userAggregateName.getTableName());
            }
            this.setUserDefinedAggregate(new UserAggregateDefinition((AliasDescriptor)object2));
            this.aggregateName = ((AliasDescriptor)object2).getJavaClassName();
        }
        this.instantiateAggDef();
        if (this.isUserDefinedAggregate()) {
            object3 = ((UserAggregateDefinition)this.uad).getAliasDescriptor();
            boolean bl2 = "SYS".equals(((AliasDescriptor)object3).getSchemaName());
            if (this.distinct && bl2) {
                throw StandardException.newException("42XAS", new Object[0]);
            }
            this.getCompilerContext().createDependency((Provider)object3);
            if (this.isPrivilegeCollectionRequired() && !bl2) {
                this.getCompilerContext().addRequiredUsagePriv((PrivilegedSQLObject)object3);
            }
        }
        list.add(this);
        object3 = this.getCompilerContext();
        if (this.operand != null) {
            int n = this.orReliability(16384);
            this.bindOperand(fromList, subqueryList, list);
            object3.setReliability(n);
            object = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept((Visitor)object);
            if (((HasNodeVisitor)object).hasNode()) {
                throw StandardException.newException("42Y33", this.getSQLName());
            }
            SelectNode.checkNoWindowFunctions(this.operand, this.aggregateName);
            dataTypeDescriptor = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dataTypeDescriptor.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(classFactory)) {
                throw StandardException.newException("X0X67.S", dataTypeDescriptor.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.getSQLName());
            }
        }
        this.aggregatorClassName = new StringBuffer();
        object2 = this.uad.getAggregator(dataTypeDescriptor, this.aggregatorClassName);
        if (object2 == null) {
            throw StandardException.newException("42Y22", this.getSQLName(), this.operand.getTypeId().getSQLTypeName());
        }
        if (this.isUserDefinedAggregate() && (object = ((UserAggregateDefinition)this.uad).castInputValue(this.operand, this.getContextManager())) != null) {
            this.operand = ((ValueNode)object).bindExpression(fromList, subqueryList, list);
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType((DataTypeDescriptor)object2);
        return this;
    }

    static AliasDescriptor resolveAggregate(DataDictionary dataDictionary, SchemaDescriptor schemaDescriptor, String string, boolean bl) throws StandardException {
        AliasDescriptor aliasDescriptor = AggregateNode.resolveBuiltinAggregate(dataDictionary, string, bl);
        if (aliasDescriptor != null) {
            return aliasDescriptor;
        }
        if (schemaDescriptor.getUUID() == null) {
            return null;
        }
        List<AliasDescriptor> list = dataDictionary.getRoutineList(schemaDescriptor.getUUID().toString(), string, 'G');
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private static AliasDescriptor resolveBuiltinAggregate(DataDictionary dataDictionary, String string, boolean bl) throws StandardException {
        if (!bl) {
            return null;
        }
        BuiltinAggDescriptor builtinAggDescriptor = null;
        for (BuiltinAggDescriptor builtinAggDescriptor2 : BUILTIN_MODERN_AGGS) {
            if (!builtinAggDescriptor2.aggName.equals(string)) continue;
            builtinAggDescriptor = builtinAggDescriptor2;
            break;
        }
        if (builtinAggDescriptor == null) {
            return null;
        }
        AggregateAliasInfo aggregateAliasInfo = new AggregateAliasInfo(builtinAggDescriptor.argType, builtinAggDescriptor.returnType);
        return new AliasDescriptor(dataDictionary, null, string, dataDictionary.getSystemSchemaDescriptor().getUUID(), builtinAggDescriptor.aggClassName, 'G', 'G', false, aggregateAliasInfo, null);
    }

    private void checkAggregatorClassName(String string) throws StandardException {
        this.verifyClassExist(string);
        if (!this.classInspector.assignableTo(string, "org.apache.derby.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", string, this.getSQLName(), this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        if (this.uad == null) {
            AggregateDefinition aggregateDefinition;
            String string;
            Class<?> clazz = this.aggregateDefinitionClass;
            if (clazz == null) {
                string = this.aggregateDefinitionClassName;
                this.verifyClassExist(string);
                try {
                    clazz = this.classInspector.getClass(string);
                }
                catch (Throwable throwable) {
                    throw StandardException.unexpectedUserException(throwable);
                }
            }
            string = null;
            try {
                string = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
            if (!(string instanceof AggregateDefinition)) {
                throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
            }
            if (string instanceof MaxMinAggregateDefinition) {
                aggregateDefinition = (MaxMinAggregateDefinition)((Object)string);
                if (this.aggregateName.equals("MAX")) {
                    ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(true);
                } else {
                    ((MaxMinAggregateDefinition)aggregateDefinition).setMaxOrMin(false);
                }
            }
            if (string instanceof SumAvgAggregateDefinition) {
                aggregateDefinition = (SumAvgAggregateDefinition)((Object)string);
                if (this.aggregateName.equals("SUM")) {
                    ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(true);
                } else {
                    ((SumAvgAggregateDefinition)aggregateDefinition).setSumOrAvg(false);
                }
            }
            this.uad = (AggregateDefinition)((Object)string);
        }
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    boolean isDistinct() {
        return this.distinct;
    }

    String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    String getAggregateName() {
        return this.aggregateName;
    }

    ResultColumn getNewAggregatorResultColumn(DataDictionary dataDictionary) throws StandardException {
        String string = this.aggregatorClassName.toString();
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string);
        ConstantNode constantNode = this.getNullNode(dataTypeDescriptor);
        constantNode.bindExpression(null, null, null);
        return new ResultColumn(this.aggregateName, (ValueNode)constantNode, this.getContextManager());
    }

    ResultColumn getNewExpressionResultColumn(DataDictionary dataDictionary) throws StandardException {
        ValueNode valueNode = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return new ResultColumn("##aggregate expression", valueNode, this.getContextManager());
    }

    ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    @Override
    public String toString() {
        return "";
    }

    boolean isConstant() {
        return false;
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    public String getSQLName() {
        if (this.isUserDefinedAggregate()) {
            return ((UserAggregateDefinition)this.uad).getAliasDescriptor().getQualifiedName();
        }
        return this.aggregateName;
    }

    private boolean isUserDefinedAggregate() {
        return this.uad instanceof UserAggregateDefinition;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.userAggregateName != null) {
            this.userAggregateName = (TableName)this.userAggregateName.accept(visitor);
        }
    }

    static final class BuiltinAggDescriptor {
        public final String aggName;
        public final String aggClassName;
        public final TypeDescriptor argType;
        public final TypeDescriptor returnType;

        public BuiltinAggDescriptor(String string, String string2, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            this.aggName = string;
            this.aggClassName = string2;
            this.argType = typeDescriptor;
            this.returnType = typeDescriptor2;
        }
    }
}

