/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.logstash.log.CustomLogEvent;
import org.logstash.log.StructuredMessage;

public class CustomLogEventSerializer
extends JsonSerializer<CustomLogEvent> {
    public void serialize(CustomLogEvent event, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("level", (Object)event.getLevel());
        generator.writeObjectField("loggerName", (Object)event.getLoggerName());
        generator.writeObjectField("timeMillis", (Object)event.getTimeMillis());
        generator.writeObjectField("thread", (Object)event.getThreadName());
        generator.writeFieldName("logEvent");
        generator.writeStartObject();
        if (event.getMessage() instanceof StructuredMessage) {
            StructuredMessage message = (StructuredMessage)event.getMessage();
            generator.writeStringField("message", message.getMessage());
            if (message.getParams() != null) {
                for (Map.Entry<Object, Object> entry : message.getParams().entrySet()) {
                    Object value = entry.getValue();
                    try {
                        generator.writeObjectField(entry.getKey().toString(), value);
                    }
                    catch (JsonMappingException e) {
                        generator.writeObjectField(entry.getKey().toString(), (Object)value.toString());
                    }
                }
            }
        } else {
            generator.writeStringField("message", event.getMessage().getFormattedMessage());
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }

    public Class<CustomLogEvent> handledType() {
        return CustomLogEvent.class;
    }
}

