/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.Output;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.logstash.plugins.PluginLookup;

public class PluginValidator {
    private static final Method[] inputMethods = Input.class.getMethods();
    private static final Method[] filterMethods = Filter.class.getMethods();
    private static final Method[] codecMethods = Codec.class.getMethods();
    private static final Method[] outputMethods = Output.class.getMethods();

    public static boolean validatePlugin(PluginLookup.PluginType type, Class<?> pluginClass) {
        switch (type) {
            case INPUT: {
                return PluginValidator.containsAllMethods(inputMethods, pluginClass.getMethods());
            }
            case FILTER: {
                return PluginValidator.containsAllMethods(filterMethods, pluginClass.getMethods());
            }
            case CODEC: {
                return PluginValidator.containsAllMethods(codecMethods, pluginClass.getMethods());
            }
            case OUTPUT: {
                return PluginValidator.containsAllMethods(outputMethods, pluginClass.getMethods());
            }
        }
        throw new IllegalStateException("Unknown plugin type for validation: " + type);
    }

    private static boolean containsAllMethods(Method[] apiMethods, Method[] pluginMethods) {
        boolean matches = true;
        int k = 0;
        while (matches && k < apiMethods.length) {
            int finalK = k++;
            matches = Arrays.stream(pluginMethods).anyMatch(m -> PluginValidator.methodsMatch(apiMethods[finalK], m));
        }
        return matches;
    }

    private static boolean methodsMatch(Method apiMethod, Method pluginMethod) {
        return apiMethod.getName().equals(pluginMethod.getName()) && apiMethod.getReturnType() == pluginMethod.getReturnType() && Arrays.equals(apiMethod.getParameterTypes(), pluginMethod.getParameterTypes());
    }
}

