/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_shapes_mesh")
public class ParShapesMesh
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTS;
    public static final int NPOINTS;
    public static final int TRIANGLES;
    public static final int NTRIANGLES;
    public static final int NORMALS;
    public static final int TCOORDS;

    public ParShapesMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParShapesMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer points(int capacity) {
        return ParShapesMesh.npoints(this.address(), capacity);
    }

    public int npoints() {
        return ParShapesMesh.nnpoints(this.address());
    }

    @NativeType(value="PAR_SHAPES_T *")
    public IntBuffer triangles(int capacity) {
        return ParShapesMesh.ntriangles(this.address(), capacity);
    }

    public int ntriangles() {
        return ParShapesMesh.nntriangles(this.address());
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer normals(int capacity) {
        return ParShapesMesh.nnormals(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer tcoords(int capacity) {
        return ParShapesMesh.ntcoords(this.address(), capacity);
    }

    public static ParShapesMesh create(long address) {
        return (ParShapesMesh)ParShapesMesh.wrap(ParShapesMesh.class, (long)address);
    }

    @Nullable
    public static ParShapesMesh createSafe(long address) {
        return address == 0L ? null : (ParShapesMesh)ParShapesMesh.wrap(ParShapesMesh.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ParShapesMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ParShapesMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static FloatBuffer npoints(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)POINTS)), (int)capacity);
    }

    public static int nnpoints(long struct) {
        return UNSAFE.getInt(null, struct + (long)NPOINTS);
    }

    public static IntBuffer ntriangles(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)TRIANGLES)), (int)capacity);
    }

    public static int nntriangles(long struct) {
        return UNSAFE.getInt(null, struct + (long)NTRIANGLES);
    }

    @Nullable
    public static FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)NORMALS)), (int)capacity);
    }

    @Nullable
    public static FloatBuffer ntcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)TCOORDS)), (int)capacity);
    }

    static {
        Struct.Layout layout = ParShapesMesh.__struct((Struct.Member[])new Struct.Member[]{ParShapesMesh.__member((int)POINTER_SIZE), ParShapesMesh.__member((int)4), ParShapesMesh.__member((int)POINTER_SIZE), ParShapesMesh.__member((int)4), ParShapesMesh.__member((int)POINTER_SIZE), ParShapesMesh.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTS = layout.offsetof(0);
        NPOINTS = layout.offsetof(1);
        TRIANGLES = layout.offsetof(2);
        NTRIANGLES = layout.offsetof(3);
        NORMALS = layout.offsetof(4);
        TCOORDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ParShapesMesh, Buffer> {
        private static final ParShapesMesh ELEMENT_FACTORY = ParShapesMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ParShapesMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer points(int capacity) {
            return ParShapesMesh.npoints(this.address(), capacity);
        }

        public int npoints() {
            return ParShapesMesh.nnpoints(this.address());
        }

        @NativeType(value="PAR_SHAPES_T *")
        public IntBuffer triangles(int capacity) {
            return ParShapesMesh.ntriangles(this.address(), capacity);
        }

        public int ntriangles() {
            return ParShapesMesh.nntriangles(this.address());
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer normals(int capacity) {
            return ParShapesMesh.nnormals(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer tcoords(int capacity) {
            return ParShapesMesh.ntcoords(this.address(), capacity);
        }
    }
}

