/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import javax.annotation.Nullable;
import org.lwjgl.nanovg.NVGLUFramebufferBGFX;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class NanoVGBGFX {
    protected NanoVGBGFX() {
        throw new UnsupportedOperationException();
    }

    public static long nnvgCreate(int _edgeaa, short _viewId, long _allocator) {
        long __functionAddress = Functions.Create;
        return JNI.invokePP((int)_edgeaa, (short)_viewId, (long)_allocator, (long)__functionAddress);
    }

    @NativeType(value="NVGcontext *")
    public static long nvgCreate(@NativeType(value="int32_t") boolean _edgeaa, @NativeType(value="bgfx_view_id_t") int _viewId, @NativeType(value="bgfx_allocator_interface_t *") long _allocator) {
        return NanoVGBGFX.nnvgCreate(_edgeaa ? 1 : 0, (short)_viewId, _allocator);
    }

    public static void nvgDelete(@NativeType(value="NVGcontext *") long _ctx) {
        long __functionAddress = Functions.Delete;
        if (Checks.CHECKS) {
            Checks.check((long)_ctx);
        }
        JNI.invokePV((long)_ctx, (long)__functionAddress);
    }

    public static void nnvgSetViewId(long _ctx, short _viewId) {
        long __functionAddress = Functions.SetViewId;
        if (Checks.CHECKS) {
            Checks.check((long)_ctx);
        }
        JNI.invokePV((long)_ctx, (short)_viewId, (long)__functionAddress);
    }

    public static void nvgSetViewId(@NativeType(value="NVGcontext *") long _ctx, @NativeType(value="bgfx_view_id_t") int _viewId) {
        NanoVGBGFX.nnvgSetViewId(_ctx, (short)_viewId);
    }

    @NativeType(value="uint16_t")
    public static short nvgGetViewId(@NativeType(value="NVGcontext *") long _ctx) {
        long __functionAddress = Functions.GetViewId;
        if (Checks.CHECKS) {
            Checks.check((long)_ctx);
        }
        return JNI.invokePS((long)_ctx, (long)__functionAddress);
    }

    public static long nnvgluCreateFramebuffer(long _ctx, int _width, int _height, int imageFlags) {
        long __functionAddress = Functions.luCreateFramebuffer;
        if (Checks.CHECKS) {
            Checks.check((long)_ctx);
        }
        return JNI.invokePP((long)_ctx, (int)_width, (int)_height, (int)imageFlags, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="NVGLUframebuffer *")
    public static NVGLUFramebufferBGFX nvgluCreateFramebuffer(@NativeType(value="NVGcontext *") long _ctx, @NativeType(value="int32_t") int _width, @NativeType(value="int32_t") int _height, @NativeType(value="int32_t") int imageFlags) {
        long __result = NanoVGBGFX.nnvgluCreateFramebuffer(_ctx, _width, _height, imageFlags);
        return NVGLUFramebufferBGFX.createSafe(__result);
    }

    public static void nnvgluBindFramebuffer(long _framebuffer) {
        long __functionAddress = Functions.luBindFramebuffer;
        JNI.invokePV((long)_framebuffer, (long)__functionAddress);
    }

    public static void nvgluBindFramebuffer(@Nullable @NativeType(value="NVGLUframebuffer *") NVGLUFramebufferBGFX _framebuffer) {
        NanoVGBGFX.nnvgluBindFramebuffer(MemoryUtil.memAddressSafe((Pointer)_framebuffer));
    }

    public static void nnvgluDeleteFramebuffer(long _framebuffer) {
        long __functionAddress = Functions.luDeleteFramebuffer;
        JNI.invokePV((long)_framebuffer, (long)__functionAddress);
    }

    public static void nvgluDeleteFramebuffer(@NativeType(value="NVGLUframebuffer *") NVGLUFramebufferBGFX _framebuffer) {
        NanoVGBGFX.nnvgluDeleteFramebuffer(_framebuffer.address());
    }

    public static void nnvgluSetViewFramebuffer(short _view_id, long _framebuffer) {
        long __functionAddress = Functions.luSetViewFramebuffer;
        JNI.invokePV((short)_view_id, (long)_framebuffer, (long)__functionAddress);
    }

    public static void nvgluSetViewFramebuffer(@NativeType(value="bgfx_view_id_t") int _view_id, @NativeType(value="NVGLUframebuffer *") NVGLUFramebufferBGFX _framebuffer) {
        NanoVGBGFX.nnvgluSetViewFramebuffer((short)_view_id, _framebuffer.address());
    }

    private static void org_lwjgl_nanovg_setup(@NativeType(value="void *") long realloc, @NativeType(value="void *") long free, @NativeType(value="void *") long nvgCreateInternal, @NativeType(value="void *") long nvgInternalParams, @NativeType(value="void *") long nvgDeleteInternal) {
        long __functionAddress = Functions.org_lwjgl_nanovg_setup;
        if (Checks.CHECKS) {
            Checks.check((long)realloc);
            Checks.check((long)free);
            Checks.check((long)nvgCreateInternal);
            Checks.check((long)nvgInternalParams);
            Checks.check((long)nvgDeleteInternal);
        }
        JNI.invokePPPPPV((long)realloc, (long)free, (long)nvgCreateInternal, (long)nvgInternalParams, (long)nvgDeleteInternal, (long)__functionAddress);
    }

    static {
        MemoryUtil.MemoryAllocator allocator = MemoryUtil.getAllocator((boolean)((Boolean)Configuration.DEBUG_MEMORY_ALLOCATOR_INTERNAL.get((Object)true)));
        NanoVGBGFX.org_lwjgl_nanovg_setup(allocator.getRealloc(), allocator.getFree(), NanoVG.nvgCreateInternal, NanoVG.nvgInternalParams, NanoVG.nvgDeleteInternal);
    }

    private static class BGFX {
        private static final SharedLibrary library;

        private BGFX() {
        }

        static SharedLibrary getLibrary() {
            return library;
        }

        static {
            try {
                library = (SharedLibrary)Class.forName("org.lwjgl.bgfx.BGFX").getMethod("getLibrary", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class Functions {
        public static final long Create = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgCreate");
        public static final long Delete = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgDelete");
        public static final long SetViewId = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgSetViewId");
        public static final long GetViewId = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgGetViewId");
        public static final long luCreateFramebuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgluCreateFramebuffer");
        public static final long luBindFramebuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgluBindFramebuffer");
        public static final long luDeleteFramebuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgluDeleteFramebuffer");
        public static final long luSetViewFramebuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"nvgluSetViewFramebuffer");
        public static final long org_lwjgl_nanovg_setup = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"org_lwjgl_nanovg_setup");

        private Functions() {
        }
    }
}

