"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLSyntaxParser = void 0;

var _antlr4ts = require("antlr4ts");

var _case_insensitive_char_stream = require("./adaptors/case_insensitive_char_stream");

var _OpenSearchPPLLexer = require("./output/OpenSearchPPLLexer");

var _OpenSearchPPLParser = require("./output/OpenSearchPPLParser");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * PPL Syntax Parser.
 */
class PPLSyntaxParser {
  /**
   * Analyze the query syntax.
   */
  parse(query) {
    return this.createParser(this.createLexer(query));
  }

  createLexer(query = '') {
    return new _OpenSearchPPLLexer.OpenSearchPPLLexer(new _case_insensitive_char_stream.CaseInsensitiveCharStream(_antlr4ts.CharStreams.fromString(query)));
  }

  createParser(lexer) {
    return new _OpenSearchPPLParser.OpenSearchPPLParser(new _antlr4ts.CommonTokenStream(lexer));
  }

}

exports.PPLSyntaxParser = PPLSyntaxParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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