"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerVizRoute = registerVizRoute;

var _notebooks = require("../../../common/constants/notebooks");

var _metrics_helper = require("../../common/metrics/metrics_helper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerVizRoute(router) {
  // Fetches available saved visualizations for current user
  router.get({
    path: `${_notebooks.NOTEBOOKS_API_PREFIX}/visualizations`,
    validate: {}
  }, async (context, request, response) => {
    (0, _metrics_helper.addRequestToMetric)('notebooks', 'fetch_visualization', 'count');
    const params = {
      index: '.kibana',
      size: _notebooks.NOTEBOOKS_FETCH_SIZE,
      q: 'type:visualization'
    };

    try {
      const opensearchClientResponse = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      const savedVisualizations = opensearchClientResponse.hits.hits;
      const vizResponse = savedVisualizations.map(vizDocument => ({
        label: vizDocument._source.visualization.title,
        key: vizDocument._id.split(':').pop()
      }));
      return response.ok({
        body: {
          savedVisualizations: vizResponse
        }
      });
    } catch (error) {
      (0, _metrics_helper.addRequestToMetric)('notebooks', 'fetch_visualization', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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