"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_PROPERTY_NAME = exports.METHOD_NAMES = exports.CLUSTER = exports.CLIENT_RULE_METHODS = exports.CLIENT_NOTIFICATIONS_METHODS = exports.CLIENT_FIELD_MAPPINGS_METHODS = exports.CLIENT_DETECTOR_METHODS = exports.CLIENT_ALERTS_METHODS = exports.BASE_API_PATH = exports.API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let CLUSTER;
exports.CLUSTER = CLUSTER;

(function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["SA"] = "opensearch_security_analytics";
  CLUSTER["DATA"] = "data";
})(CLUSTER || (exports.CLUSTER = CLUSTER = {}));

const BASE_API_PATH = '/_plugins/_security_analytics';
exports.BASE_API_PATH = BASE_API_PATH;
const API = {
  DETECTORS_BASE: `${BASE_API_PATH}/detectors`,
  SEARCH_DETECTORS: `${BASE_API_PATH}/detectors/_search`,
  INDICES_BASE: `${BASE_API_PATH}/indices`,
  GET_FINDINGS: `${BASE_API_PATH}/findings/_search`,
  DOCUMENT_IDS_QUERY: `${BASE_API_PATH}/document_ids_query`,
  TIME_RANGE_QUERY: `${BASE_API_PATH}/time_range_query`,
  MAPPINGS_BASE: `${BASE_API_PATH}/mappings`,
  MAPPINGS_VIEW: `${BASE_API_PATH}/mappings/view`,
  GET_ALERTS: `${BASE_API_PATH}/alerts`,
  RULES_BASE: `${BASE_API_PATH}/rules`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  PLUGINS: `${BASE_API_PATH}/_notifications/plugins`,
  ACKNOWLEDGE_ALERTS: `${BASE_API_PATH}/detectors/{detector_id}/_acknowledge/alerts`,
  UPDATE_ALIASES: `${BASE_API_PATH}/update_aliases`
};
/**
 * Property with below name is added to the prototype of Opensearch client during setup.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */

exports.API = API;
const PLUGIN_PROPERTY_NAME = 'securityAnalytics';
exports.PLUGIN_PROPERTY_NAME = PLUGIN_PROPERTY_NAME;
const METHOD_NAMES = {
  //Rule methods
  CREATE_RULE: 'createRule',
  DELETE_RULE: 'deleteRule',
  GET_RULE: 'getRule',
  GET_RULES: 'getRules',
  UPDATE_RULE: 'updateRules',
  // Detector methods
  CREATE_DETECTOR: 'createDetector',
  DELETE_DETECTOR: 'deleteDetector',
  GET_DETECTOR: 'getDetector',
  SEARCH_DETECTORS: 'searchDetectors',
  UPDATE_DETECTOR: 'updateDetector',
  // Finding methods
  GET_FINDINGS: 'getFindings',
  // Field mapping methods
  GET_MAPPINGS_VIEW: 'getFieldMappingsView',
  CREATE_MAPPINGS: 'createMappings',
  GET_MAPPINGS: 'getMappings',
  // Alerts methods
  GET_ALERTS: 'getAlerts',
  ACKNOWLEDGE_ALERTS: 'acknowledgeAlerts',
  // Notifications methods
  GET_CHANNEl: 'getChannel',
  GET_CHANNElS: 'getChannels'
};
/**
 * These methods are defined on the Opensearch client instance by adding them to the client's
 * prototype under the @see PLUGIN_PROPERTY_NAME field.
 * @see ../clusters/securityAnalytics/securityAnalyticsPlugin
 */

exports.METHOD_NAMES = METHOD_NAMES;
const CLIENT_RULE_METHODS = {
  CREATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_RULE}`,
  DELETE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_RULE}`,
  GET_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULE}`,
  GET_RULES: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_RULES}`,
  UPDATE_RULE: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_RULE}`
};
exports.CLIENT_RULE_METHODS = CLIENT_RULE_METHODS;
const CLIENT_DETECTOR_METHODS = {
  CREATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_DETECTOR}`,
  DELETE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.DELETE_DETECTOR}`,
  GET_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_DETECTOR}`,
  SEARCH_DETECTORS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.SEARCH_DETECTORS}`,
  UPDATE_DETECTOR: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.UPDATE_DETECTOR}`,
  GET_FINDINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_FINDINGS}`
};
exports.CLIENT_DETECTOR_METHODS = CLIENT_DETECTOR_METHODS;
const CLIENT_FIELD_MAPPINGS_METHODS = {
  GET_MAPPINGS_VIEW: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS_VIEW}`,
  CREATE_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.CREATE_MAPPINGS}`,
  GET_MAPPINGS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_MAPPINGS}`
};
exports.CLIENT_FIELD_MAPPINGS_METHODS = CLIENT_FIELD_MAPPINGS_METHODS;
const CLIENT_ALERTS_METHODS = {
  ACKNOWLEDGE_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.ACKNOWLEDGE_ALERTS}`,
  GET_ALERTS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_ALERTS}`
};
exports.CLIENT_ALERTS_METHODS = CLIENT_ALERTS_METHODS;
const CLIENT_NOTIFICATIONS_METHODS = {
  GET_CHANNEL: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNEl}`,
  GET_CHANNELS: `${PLUGIN_PROPERTY_NAME}.${METHOD_NAMES.GET_CHANNElS}`
};
exports.CLIENT_NOTIFICATIONS_METHODS = CLIENT_NOTIFICATIONS_METHODS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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