"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
const PLUGIN_ID = 'opensearchDashboardsSecurity';
exports.PLUGIN_ID = PLUGIN_ID;
const PLUGIN_NAME = 'security-dashboards-plugin';
exports.PLUGIN_NAME = PLUGIN_NAME;
const APP_ID_LOGIN = 'login';
exports.APP_ID_LOGIN = APP_ID_LOGIN;
const APP_ID_CUSTOMERROR = 'customerror';
exports.APP_ID_CUSTOMERROR = APP_ID_CUSTOMERROR;
const OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
exports.OPENDISTRO_SECURITY_ANONYMOUS = OPENDISTRO_SECURITY_ANONYMOUS;
const API_PREFIX = '/api/v1';
exports.API_PREFIX = API_PREFIX;
const CONFIGURATION_API_PREFIX = 'configuration';
exports.CONFIGURATION_API_PREFIX = CONFIGURATION_API_PREFIX;
const API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
exports.API_ENDPOINT_AUTHINFO = API_ENDPOINT_AUTHINFO;
const API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
exports.API_ENDPOINT_AUTHTYPE = API_ENDPOINT_AUTHTYPE;
const LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
exports.LOGIN_PAGE_URI = LOGIN_PAGE_URI;
const CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
exports.CUSTOM_ERROR_PAGE_URI = CUSTOM_ERROR_PAGE_URI;
const API_AUTH_LOGIN = '/auth/login';
exports.API_AUTH_LOGIN = API_AUTH_LOGIN;
const API_AUTH_LOGOUT = '/auth/logout';
exports.API_AUTH_LOGOUT = API_AUTH_LOGOUT;
const OPENID_AUTH_LOGIN = '/auth/openid/login';
exports.OPENID_AUTH_LOGIN = OPENID_AUTH_LOGIN;
const SAML_AUTH_LOGIN = '/auth/saml/login';
exports.SAML_AUTH_LOGIN = SAML_AUTH_LOGIN;
const ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
exports.ANONYMOUS_AUTH_LOGIN = ANONYMOUS_AUTH_LOGIN;
const SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment?nextUrl=%2F';
exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = SAML_AUTH_LOGIN_WITH_FRAGMENT;
const OPENID_AUTH_LOGOUT = '/auth/openid/logout';
exports.OPENID_AUTH_LOGOUT = OPENID_AUTH_LOGOUT;
const SAML_AUTH_LOGOUT = '/auth/saml/logout';
exports.SAML_AUTH_LOGOUT = SAML_AUTH_LOGOUT;
const ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
exports.ANONYMOUS_AUTH_LOGOUT = ANONYMOUS_AUTH_LOGOUT;
const ERROR_MISSING_ROLE_PATH = '/missing-role';
exports.ERROR_MISSING_ROLE_PATH = ERROR_MISSING_ROLE_PATH;
const AUTH_HEADER_NAME = 'authorization';
exports.AUTH_HEADER_NAME = AUTH_HEADER_NAME;
const AUTH_GRANT_TYPE = 'authorization_code';
exports.AUTH_GRANT_TYPE = AUTH_GRANT_TYPE;
const AUTH_RESPONSE_TYPE = 'code';
exports.AUTH_RESPONSE_TYPE = AUTH_RESPONSE_TYPE;
const GLOBAL_TENANT_SYMBOL = '';
exports.GLOBAL_TENANT_SYMBOL = GLOBAL_TENANT_SYMBOL;
const PRIVATE_TENANT_SYMBOL = '__user__';
exports.PRIVATE_TENANT_SYMBOL = PRIVATE_TENANT_SYMBOL;
const DEFAULT_TENANT = 'default';
exports.DEFAULT_TENANT = DEFAULT_TENANT;
const GLOBAL_TENANT_RENDERING_TEXT = 'Global';
exports.GLOBAL_TENANT_RENDERING_TEXT = GLOBAL_TENANT_RENDERING_TEXT;
const PRIVATE_TENANT_RENDERING_TEXT = 'Private';
exports.PRIVATE_TENANT_RENDERING_TEXT = PRIVATE_TENANT_RENDERING_TEXT;
const globalTenantName = 'global_tenant';
exports.globalTenantName = globalTenantName;
const MAX_INTEGER = 2147483647;
exports.MAX_INTEGER = MAX_INTEGER;
let AuthType;
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */

exports.AuthType = AuthType;

(function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
})(AuthType || (exports.AuthType = AuthType = {}));

function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}

function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}

function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}

function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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