/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.data.UserKeymap;
import org.jetbrains.projector.server.core.ij.KeymapSetter;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.loading.state.IdeState;
import org.jetbrains.projector.util.loading.state.IdeStateUtilsKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/server/core/ij/KeymapSetter;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "setKeymap", "", "keymap", "Lorg/jetbrains/projector/common/protocol/data/UserKeymap;", "toKeyMapManagerFieldName", "", "projector-server-core"})
public final class KeymapSetter {
    @NotNull
    public static final KeymapSetter INSTANCE = new KeymapSetter();
    @NotNull
    private static final Logger logger;

    private KeymapSetter() {
    }

    private final String toKeyMapManagerFieldName(UserKeymap $this$toKeyMapManagerFieldName) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toKeyMapManagerFieldName.ordinal()]) {
            case 1: {
                string = "Default for XWin";
                break;
            }
            case 2: {
                string = "Mac OS X 10.5+";
                break;
            }
            case 3: {
                string = "Default for GNOME";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final void setKeymap(@NotNull UserKeymap keymap) {
        Intrinsics.checkNotNullParameter((Object)((Object)keymap), (String)"keymap");
        IdeStateUtilsKt.whenOccurred(IdeState.CONFIGURATION_STORE_INITIALIZED, "set keymap to match user's OS (" + keymap + ")", (Function0<Unit>)((Function0)new Function0<Unit>(keymap){
            final /* synthetic */ UserKeymap $keymap;
            {
                this.$keymap = $keymap;
                super(0);
            }

            public final void invoke() {
                SwingUtilities.invokeLater(() -> setKeymap.1.invoke$lambda-1(this.$keymap));
            }

            private static final void invoke$lambda-1(UserKeymap $keymap) {
                Intrinsics.checkNotNullParameter((Object)((Object)$keymap), (String)"$keymap");
                KeymapManagerEx keymapManagerExInstance = KeymapManagerEx.getInstanceEx();
                String userKeymapName = KeymapSetter.access$toKeyMapManagerFieldName(KeymapSetter.INSTANCE, $keymap);
                Keymap keymap = keymapManagerExInstance.getKeymap(userKeymapName);
                if (keymap == null) {
                    KeymapSetter $this$invoke_u24lambda_u2d1_u24lambda_u2d0 = KeymapSetter.INSTANCE;
                    boolean bl = false;
                    Logger.DefaultImpls.error$default(KeymapSetter.access$getLogger$p(), null, (Function0)new Function0<String>(userKeymapName){
                        final /* synthetic */ String $userKeymapName;
                        {
                            this.$userKeymapName = $userKeymapName;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "getKeymap(" + this.$userKeymapName + ") == null - skipping setting keymap";
                        }
                    }, 1, null);
                    return;
                }
                Keymap keymapInstance2 = keymap;
                keymapManagerExInstance.setActiveKeymap(keymapInstance2);
            }
        }));
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ String access$toKeyMapManagerFieldName(KeymapSetter $this, UserKeymap $receiver) {
        return $this.toKeyMapManagerFieldName($receiver);
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(KeymapSetter.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UserKeymap.values().length];
            nArray[UserKeymap.WINDOWS.ordinal()] = 1;
            nArray[UserKeymap.MAC.ordinal()] = 2;
            nArray[UserKeymap.LINUX.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

