/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.pcollections;

import kotlin.reflect.jvm.internal.pcollections.ConsPStack;
import kotlin.reflect.jvm.internal.pcollections.IntTreePMap;
import kotlin.reflect.jvm.internal.pcollections.MapEntry;
import org.jetbrains.annotations.NotNull;

public final class HashPMap<K, V> {
    private static final HashPMap<Object, Object> EMPTY = new HashPMap(IntTreePMap.empty(), 0);
    private final IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap;
    private final int size;

    @NotNull
    public static <K, V> HashPMap<K, V> empty() {
        HashPMap<Object, Object> hashPMap = EMPTY;
        if (hashPMap == null) {
            HashPMap.$$$reportNull$$$0(0);
        }
        return hashPMap;
    }

    private HashPMap(IntTreePMap<ConsPStack<MapEntry<K, V>>> intMap, int size) {
        this.intMap = intMap;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return HashPMap.keyIndexIn(this.getEntries(key.hashCode()), key) != -1;
    }

    public V get(Object key) {
        ConsPStack<MapEntry<K, V>> entries2 = this.getEntries(key.hashCode());
        while (entries2 != null && entries2.size() > 0) {
            MapEntry entry = (MapEntry)entries2.first;
            if (entry.key.equals(key)) {
                return entry.value;
            }
            entries2 = entries2.rest;
        }
        return null;
    }

    @NotNull
    public HashPMap<K, V> plus(K key, V value) {
        ConsPStack<MapEntry<K, V>> entries2 = this.getEntries(key.hashCode());
        int size0 = entries2.size();
        int i = HashPMap.keyIndexIn(entries2, key);
        if (i != -1) {
            entries2 = entries2.minus(i);
        }
        entries2 = entries2.plus(new MapEntry<K, V>(key, value));
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries2), this.size - size0 + entries2.size());
    }

    @NotNull
    public HashPMap<K, V> minus(Object key) {
        ConsPStack<MapEntry<K, V>> entries2 = this.getEntries(key.hashCode());
        int i = HashPMap.keyIndexIn(entries2, key);
        if (i == -1) {
            HashPMap hashPMap = this;
            if (hashPMap == null) {
                HashPMap.$$$reportNull$$$0(1);
            }
            return hashPMap;
        }
        if ((entries2 = entries2.minus(i)).size() == 0) {
            return new HashPMap<K, V>(this.intMap.minus(key.hashCode()), this.size - 1);
        }
        return new HashPMap<K, V>(this.intMap.plus(key.hashCode(), entries2), this.size - 1);
    }

    private ConsPStack<MapEntry<K, V>> getEntries(int hash) {
        ConsPStack<MapEntry<K, V>> entries2 = this.intMap.get(hash);
        if (entries2 == null) {
            return ConsPStack.empty();
        }
        return entries2;
    }

    private static <K, V> int keyIndexIn(ConsPStack<MapEntry<K, V>> entries2, Object key) {
        int i = 0;
        while (entries2 != null && entries2.size() > 0) {
            MapEntry entry = (MapEntry)entries2.first;
            if (entry.key.equals(key)) {
                return i;
            }
            entries2 = entries2.rest;
            ++i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "kotlin/reflect/jvm/internal/pcollections/HashPMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

