/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestinationImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "()[Lcom/intellij/psi/PsiReference;", "Manipulator", "intellij.markdown.core"})
public final class MarkdownLinkDestination
extends MarkdownLinkDestinationImpl {
    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitLinkDestination(this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)((PsiElement)this));
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"ReferenceProvidersRegist\u2026rencesFromProviders(this)");
        return psiReferenceArray;
    }

    public MarkdownLinkDestination(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "intellij.markdown.core"})
    public static final class Manipulator
    extends AbstractElementManipulator<MarkdownLinkDestination> {
        @NotNull
        public MarkdownLinkDestination handleContentChange(@NotNull MarkdownLinkDestination element2, @NotNull TextRange range, @NotNull String newContent) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            PsiElement child = element2.getFirstChild();
            if (!(child instanceof LeafPsiElement)) {
                throw (Throwable)new IncorrectOperationException("Bad child");
            }
            ((LeafPsiElement)child).replaceWithText(range.replace(((LeafPsiElement)child).getText(), newContent));
            return element2;
        }

        @NotNull
        public TextRange getRangeInElement(@NotNull MarkdownLinkDestination element2) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            String text = element2.getText();
            String string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            if (StringsKt.startsWith$default((String)string, (String)"<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)">", (boolean)false, (int)2, null)) {
                textRange = new TextRange(1, text.length() - 1);
            } else {
                TextRange textRange2 = TextRange.allOf((String)text);
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"TextRange.allOf(text)");
            }
            return textRange;
        }
    }
}

