/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;
import com.jetbrains.python.debugger.dataframe.DataViewCellRenderer;
import java.awt.Color;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

class ArrayTableCellRenderer
extends DataViewCellRenderer
implements ColoredCellRenderer {
    private static final Logger LOG = Logger.getInstance(ArrayTableCellRenderer.class);
    private double myMin = Double.MIN_VALUE;
    private double myMax = Double.MIN_VALUE;
    private String myComplexMin;
    private String myComplexMax;
    private boolean myColored = true;
    private final String myType;

    ArrayTableCellRenderer(double min, double max, String type) {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(0);
        this.myMin = min;
        this.myMax = max;
        this.myType = type;
    }

    @Override
    public void setColored(boolean colored) {
        this.myColored = colored;
    }

    @Override
    protected void colorize(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background = null;
        if (this.myMax != this.myMin && this.myColored && value != null) {
            try {
                String valueStr = value.toString();
                if (!valueStr.isEmpty()) {
                    double rangedValue = PyNumericViewUtil.getRangedValue(valueStr, this.myType, this.myMin, this.myMax, this.myComplexMax, this.myComplexMin);
                    background = PyNumericViewUtil.rangedValueToColor(rangedValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setBackground(background);
    }

    public void setMin(double min) {
        this.myMin = min;
    }

    public void setMax(double max) {
        this.myMax = max;
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public void fillColorRange(@NotNull String minValue, @NotNull String maxValue) {
        if (minValue == null) {
            ArrayTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (maxValue == null) {
            ArrayTableCellRenderer.$$$reportNull$$$0(1);
        }
        if ("c".equals(this.myType)) {
            this.myMin = 0.0;
            this.myMax = 1.0;
            this.myComplexMin = minValue;
            this.myComplexMax = maxValue;
            return;
        }
        if ("b".equals(this.myType)) {
            this.myMin = "True".equals(minValue) ? 1.0 : 0.0;
            this.myMax = "True".equals(maxValue) ? 1.0 : 0.0;
            return;
        }
        try {
            this.myMin = Double.parseDouble(minValue);
            this.myMax = Double.parseDouble(maxValue);
        }
        catch (NumberFormatException e) {
            LOG.error(String.format("Wrong bounds for '%s' type: minValue = %s, maxValue = %s", this.myType, minValue, maxValue));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "minValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "maxValue";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/array/ArrayTableCellRenderer";
        objectArray[2] = "fillColorRange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

