/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

@State(name="PyCondaPackageService", storages={@Storage(value="conda_packages.xml", roamingType=RoamingType.DISABLED)})
public class PyCondaPackageService
implements PersistentStateComponent<PyCondaPackageService> {
    private static final Logger LOG = Logger.getInstance(PyCondaPackageService.class);
    private static final String[] CONDA_DEFAULT_ROOTS = new String[]{"anaconda", "anaconda3", "miniconda", "miniconda3", "Anaconda", "Anaconda3", "Miniconda", "Miniconda3"};
    private static final String CONDA_ENVS_DIR = "envs";
    @Property
    @Nullable
    private @SystemDependent String PREFERRED_CONDA_PATH = null;

    public PyCondaPackageService getState() {
        return this;
    }

    public void loadState(@NotNull PyCondaPackageService state2) {
        if (state2 == null) {
            PyCondaPackageService.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public static PyCondaPackageService getInstance() {
        return (PyCondaPackageService)ApplicationManager.getApplication().getService(PyCondaPackageService.class);
    }

    @Nullable
    private static String getCondaPython() {
        String python;
        String conda = PyCondaPackageService.getCondaExecutable(null);
        if (conda != null && (python = PyCondaPackageService.getCondaBasePython(conda)) != null) {
            return python;
        }
        return PyCondaPackageService.getCondaExecutableByName(PyCondaPackageService.getPythonName());
    }

    @Nullable
    public static String getCondaBasePython(@NotNull String systemCondaExecutable) {
        VirtualFile condaDir;
        VirtualFile python;
        VirtualFile condaFile;
        if (systemCondaExecutable == null) {
            PyCondaPackageService.$$$reportNull$$$0(1);
        }
        if ((condaFile = LocalFileSystem.getInstance().findFileByPath(systemCondaExecutable)) != null && (python = (condaDir = SystemInfo.isWindows ? condaFile.getParent().getParent() : condaFile.getParent()).findChild(PyCondaPackageService.getPythonName())) != null) {
            return python.getPath();
        }
        return null;
    }

    @NotNull
    private static String getPythonName() {
        return SystemInfo.isWindows ? "python.exe" : "python";
    }

    @Nullable
    private static String getSystemCondaExecutable() {
        String condaName = SystemInfo.isWindows ? "conda.exe" : "conda";
        File condaInPath = PathEnvironmentVariableUtil.findInPath((String)condaName);
        if (condaInPath != null) {
            LOG.info("Using " + condaInPath + " as a conda executable (found in PATH)");
            return condaInPath.getPath();
        }
        String condaInRoots = PyCondaPackageService.getCondaExecutableByName(condaName);
        if (condaInRoots != null) {
            LOG.info("Using " + condaInRoots + " as a conda executable (found by visiting possible conda roots)");
            return condaInRoots;
        }
        LOG.info("System conda executable is not found");
        return null;
    }

    @Nullable
    public static @SystemDependent String getCondaExecutable(@Nullable String sdkPath) {
        String condaPath;
        if (sdkPath != null && (condaPath = PyCondaPackageService.findCondaExecutableRelativeToEnv(sdkPath)) != null) {
            LOG.info("Using " + condaPath + " as a conda executable for " + sdkPath + " (found as a relative to the env)");
            return condaPath;
        }
        String preferredCondaPath = PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH;
        if (StringUtil.isNotEmpty((String)preferredCondaPath)) {
            Object forSdkPath = sdkPath == null ? "" : " for " + sdkPath;
            LOG.info("Using " + preferredCondaPath + " as a conda executable" + (String)forSdkPath + " (specified as a preferred conda path)");
            return preferredCondaPath;
        }
        return PyCondaPackageService.getSystemCondaExecutable();
    }

    public static void onCondaEnvCreated(@NotNull @SystemDependent String condaExecutable) {
        if (condaExecutable == null) {
            PyCondaPackageService.$$$reportNull$$$0(2);
        }
        PyCondaPackageService.getInstance().PREFERRED_CONDA_PATH = condaExecutable;
    }

    @Nullable
    private static String findCondaExecutableRelativeToEnv(@NotNull String sdkPath) {
        VirtualFile condaFolder;
        String condaName;
        boolean isBaseConda;
        VirtualFile pyExecutable;
        if (sdkPath == null) {
            PyCondaPackageService.$$$reportNull$$$0(3);
        }
        if ((pyExecutable = StandardFileSystems.local().findFileByPath(sdkPath)) == null) {
            return null;
        }
        VirtualFile pyExecutableDir = pyExecutable.getParent();
        boolean bl = isBaseConda = pyExecutableDir.findChild(CONDA_ENVS_DIR) != null;
        if (SystemInfo.isWindows) {
            condaName = "conda.exe";
            condaFolder = pyExecutableDir;
        } else {
            condaName = "conda";
            condaFolder = pyExecutableDir.getParent();
        }
        String localCondaName = SystemInfo.isWindows && !isBaseConda ? "conda.bat" : condaName;
        String immediateConda = PyCondaPackageService.findExecutable(localCondaName, condaFolder);
        if (immediateConda != null) {
            return immediateConda;
        }
        VirtualFile envsDir = condaFolder.getParent();
        if (!isBaseConda && envsDir != null && envsDir.getName().equals(CONDA_ENVS_DIR)) {
            return PyCondaPackageService.findExecutable(condaName, envsDir.getParent());
        }
        return null;
    }

    @Nullable
    private static String getCondaExecutableByName(@NotNull String condaName) {
        if (condaName == null) {
            PyCondaPackageService.$$$reportNull$$$0(4);
        }
        VirtualFile userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'));
        for (String root : CONDA_DEFAULT_ROOTS) {
            VirtualFile condaFolder = userHome == null ? null : userHome.findChild(root);
            String executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
            if (executableFile != null) {
                return executableFile;
            }
            if (SystemInfo.isWindows) {
                condaFolder = userHome == null ? null : userHome.findFileByRelativePath("AppData\\Local\\Continuum\\" + root);
                executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                if (executableFile != null) {
                    return executableFile;
                }
                condaFolder = LocalFileSystem.getInstance().findFileByPath("C:\\ProgramData\\" + root);
                executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                if (executableFile != null) {
                    return executableFile;
                }
                condaFolder = LocalFileSystem.getInstance().findFileByPath("C:\\" + root);
                executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
                if (executableFile == null) continue;
                return executableFile;
            }
            condaFolder = LocalFileSystem.getInstance().findFileByPath("/opt/" + root);
            executableFile = PyCondaPackageService.findExecutable(condaName, condaFolder);
            if (executableFile == null) continue;
            return executableFile;
        }
        return null;
    }

    @Nullable
    private static String findExecutable(String condaName, @Nullable VirtualFile condaFolder) {
        String directoryPath2;
        String executableFile;
        VirtualFile bin;
        VirtualFile binFolder;
        if (condaFolder != null && (binFolder = condaFolder.findChild(SystemInfo.isWindows ? "Scripts" : "bin")) != null && (bin = binFolder.findChild(condaName)) != null && (executableFile = PythonSdkUtil.getExecutablePath(directoryPath2 = bin.getPath(), condaName)) != null) {
            return executableFile;
        }
        return null;
    }

    @Nullable
    public static Multimap<String, String> listAllPackagesAndVersions() {
        try {
            String output = PyCondaPackageService.runCondaPackagingHelper("listall");
            SortedSetMultimap nameToVersions = Multimaps.newSortedSetMultimap(new HashMap(), () -> new TreeSet<String>(PyPackageVersionComparator.getSTR_COMPARATOR().reversed()));
            for (String line2 : StringUtil.split((String)output, (String)"\n")) {
                List split = StringUtil.split((String)line2, (String)"\t");
                if (split.size() < 2) continue;
                nameToVersions.put((Object)((String)split.get(0)), (Object)((String)split.get(1)));
            }
            return nameToVersions;
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to get list of conda packages. " + e);
            return null;
        }
    }

    @NotNull
    public static List<String> listPackageVersions(@NotNull String packageName) throws ExecutionException {
        if (packageName == null) {
            PyCondaPackageService.$$$reportNull$$$0(5);
        }
        String output = PyCondaPackageService.runCondaPackagingHelper("versions", packageName);
        List list = StringUtil.split((String)output, (String)"\n");
        if (list == null) {
            PyCondaPackageService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<String> listChannels() throws ExecutionException {
        String output = PyCondaPackageService.runCondaPackagingHelper("channels");
        List list = StringUtil.split((String)output, (String)"\n");
        if (list == null) {
            PyCondaPackageService.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static String runCondaPackagingHelper(String ... args2) throws ExecutionException {
        if (args2 == null) {
            PyCondaPackageService.$$$reportNull$$$0(8);
        }
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add(PythonHelpersLocator.getHelperPath("conda_packaging_tool.py"));
        commandArgs.addAll(Arrays.asList(args2));
        String condaPython = PyCondaPackageService.getCondaPython();
        if (condaPython == null) {
            throw new PyExecutionException(PySdkBundle.message("python.conda.cannot.find.python.executable", new Object[0]), "python", commandArgs, new ProcessOutput());
        }
        ProcessOutput output = PyCondaRunKt.runCondaPython(condaPython, commandArgs);
        String string = output.getStdout();
        if (string == null) {
            PyCondaPackageService.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemCondaExecutable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condaExecutable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condaName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageVersions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listChannels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runCondaPackagingHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCondaBasePython";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCondaEnvCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCondaExecutableRelativeToEnv";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCondaExecutableByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listPackageVersions";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runCondaPackagingHelper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

