/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagementService
extends PackageManagementServiceEx {
    @NotNull
    private static final Pattern PATTERN_ERROR_LINE = Pattern.compile(".*error:.*", 2);
    @NonNls
    private static final String TEXT_PREFIX = PyPackageManagementService.buildHtmlStylePrefix();
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    @NotNull
    private final Project myProject;
    @NotNull
    protected final Sdk mySdk;
    protected final ExecutorService myExecutorService;
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";

    @NotNull
    private static String buildHtmlStylePrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PyPackageManagementService(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageManagementService.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            PyPackageManagementService.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySdk = sdk;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PyPackageManagementService Pool", (int)4);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagementService.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PyPackageManagementService.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    public List<String> getAllRepositories() {
        ArrayList<String> result = new ArrayList<String>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result.add("https://pypi.python.org/simple");
        }
        result.addAll(PyPackageManagementService.getAdditionalRepositories());
        return result;
    }

    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.loadPackages();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), false);
        List<RepoPackage> list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.updatePyPICache();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.getAdditionalRepositories(), true);
        List<RepoPackage> list = this.getAllPackagesCached();
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        ArrayList<RepoPackage> result = new ArrayList<RepoPackage>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            result.addAll(PyPackageManagementService.getCachedPyPIPackages());
        }
        result.addAll(PyPIPackageUtil.INSTANCE.getAdditionalPackages(PyPackageManagementService.getAdditionalRepositories()));
        ArrayList<RepoPackage> arrayList = result;
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public Map<String, List<RepoPackage>> getAllPackagesByRepository() {
        HashMap<String, List<RepoPackage>> result = new HashMap<String, List<RepoPackage>>();
        result.put("https://pypi.python.org/simple", PyPackageManagementService.getCachedPyPIPackages());
        List<String> repositories = PyPackageManagementService.getAdditionalRepositories();
        for (String repo : repositories) {
            result.put(repo, PyPIPackageUtil.INSTANCE.getAdditionalPackages(List.of(repo)));
        }
        return result;
    }

    @NotNull
    private static List<String> getAdditionalRepositories() {
        List<String> list = PyPackageService.getInstance().additionalRepositories;
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<RepoPackage> getCachedPyPIPackages() {
        boolean customRepoConfigured = !PyPackageManagementService.getAdditionalRepositories().isEmpty();
        String url = customRepoConfigured ? "https://pypi.python.org/simple" : "";
        List list = ContainerUtil.map(PyPIPackageCache.getInstance().getPackageNames(), name2 -> new RepoPackage(name2, url, null));
        if (list == null) {
            PyPackageManagementService.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean canInstallToUser() {
        return !PythonSdkUtil.isVirtualEnv(this.mySdk);
    }

    @NotNull
    public String getInstallToUserText() {
        Object userSiteText = PyBundle.message("button.install.to.user.site.packages.directory", new Object[0]);
        if (!PythonSdkUtil.isRemote(this.mySdk)) {
            userSiteText = (String)userSiteText + " (" + PythonSdkUtil.getUserSite() + ")";
        }
        String string = userSiteText;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @NotNull
    public List<? extends InstalledPackage> getInstalledPackagesList() throws ExecutionException {
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>(PyPackageManager.getInstance(this.mySdk).refreshAndGetPackages(true));
        packages.sort(Comparator.comparing(InstalledPackage::getName));
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyPackageManagementService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void installPackage(final @NotNull RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, final @NotNull PackageManagementService.Listener listener2, boolean installToUser) {
        if (repoPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(12);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(13);
        }
        final String packageName = repoPackage.getName();
        String repository = PyPIPackageUtil.isPyPIRepository(repoPackage.getRepoUrl()) ? null : repoPackage.getRepoUrl();
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (installToUser) {
            extraArgs.add("--user");
        }
        if (extraOptions != null) {
            Collections.addAll(extraArgs, extraOptions.split(" +"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)repository)) {
            extraArgs.add("--index-url");
            extraArgs.add(repository);
        }
        if (forceUpgrade) {
            extraArgs.add("-U");
        }
        PyRequirement req = version == null ? PyRequirementsKt.pyRequirement(packageName) : PyRequirementsKt.pyRequirement(packageName, PyRequirementRelation.EQ, version);
        PyPackageManagerUI ui2 = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName);
            }

            @Override
            public void finished(@Nullable List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName, (PackageManagementService.ErrorDescription)PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk, repoPackage.getName()));
            }
        });
        ui2.install(Collections.singletonList(req), extraArgs);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk) {
        return PyPackageManagementService.toErrorDescription(exceptions, sdk, null);
    }

    @Nullable
    public static PyPackageInstallationErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk, @Nullable String packageName) {
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.isCancelled(exceptions)) {
            return PyPackageManagementService.createDescription(exceptions.get(0), sdk, packageName);
        }
        return null;
    }

    public void uninstallPackages(List<? extends InstalledPackage> installedPackages2, final @NotNull PackageManagementService.Listener listener2) {
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(14);
        }
        final String packageName = installedPackages2.size() == 1 ? installedPackages2.get(0).getName() : null;
        PyPackageManagerUI ui2 = new PyPackageManagerUI(this.myProject, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(packageName);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener2.operationFinished(packageName, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> pyPackages = new ArrayList<PyPackage>();
        for (InstalledPackage installedPackage : installedPackages2) {
            if (!(installedPackage instanceof PyPackage)) continue;
            pyPackages.add((PyPackage)installedPackage);
        }
        ui2.uninstall(pyPackages);
    }

    public void fetchPackageVersions(String packageName, CatchingConsumer<? super List<String>, ? super Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName, consumer);
    }

    public void fetchPackageDetails(@NotNull String packageName, final CatchingConsumer<? super @Nls String, ? super Exception> consumer) {
        if (packageName == null) {
            PyPackageManagementService.$$$reportNull$$$0(15);
        }
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName, new CatchingConsumer<PyPIPackageUtil.PackageDetails.Info, Exception>(){

            public void consume(PyPIPackageUtil.PackageDetails.Info details) {
                consumer.consume((Object)PyPackageManagementService.formatPackageInfo(details));
            }

            public void consume(Exception e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    private static String formatPackageInfo(@NotNull PyPIPackageUtil.PackageDetails.Info info) {
        String homePage;
        String authorEmail;
        String author;
        String version;
        if (info == null) {
            PyPackageManagementService.$$$reportNull$$$0(16);
        }
        StringBuilder stringBuilder = new StringBuilder(TEXT_PREFIX);
        String description = info.getSummary();
        if (StringUtil.isNotEmpty((String)description)) {
            stringBuilder.append(description).append("<br/>");
        }
        if (StringUtil.isNotEmpty((String)(version = info.getVersion()))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(version);
        }
        if (StringUtil.isNotEmpty((String)(author = info.getAuthor()))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(author).append("<br/><br/>");
        }
        if (StringUtil.isNotEmpty((String)(authorEmail = info.getAuthorEmail()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref("mailto:" + authorEmail));
        }
        if (StringUtil.isNotEmpty((String)(homePage = info.getHomePage()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.composeHref(homePage));
        }
        stringBuilder.append(TEXT_SUFFIX);
        return stringBuilder.toString();
    }

    @NotNull
    private static String composeHref(String vendorUrl) {
        String string = HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
        if (string == null) {
            PyPackageManagementService.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isCancelled(@NotNull List<ExecutionException> exceptions) {
        if (exceptions == null) {
            PyPackageManagementService.$$$reportNull$$$0(18);
        }
        for (ExecutionException e : exceptions) {
            if (!(e instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PyPackageInstallationErrorDescription createDescription(@NotNull ExecutionException e, @Nullable Sdk sdk, @Nullable String packageName) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(19);
        }
        if (e instanceof PyExecutionException) {
            PyExecutionException ee = (PyExecutionException)((Object)e);
            String stdout = ee.getStdout();
            String stdoutCause = PyPackageManagementService.findErrorCause(stdout);
            String stderrCause = PyPackageManagementService.findErrorCause(ee.getStderr());
            String cause = stdoutCause != null ? stdoutCause : stderrCause;
            String message = cause != null ? cause : ee.getMessage();
            String command = ee.getCommand() + " " + StringUtil.join(ee.getArgs(), (String)" ");
            return new PyPackageInstallationErrorDescription(message, command, (String)(stdout.isEmpty() ? ee.getStderr() : stdout + "\n" + ee.getStderr()), PyPackageManagementService.findErrorSolution(ee, cause, sdk), packageName, sdk);
        }
        return new PyPackageInstallationErrorDescription(e.getMessage(), null, null, null, packageName, sdk);
    }

    @Nullable
    @NlsContexts.DetailedDescription
    private static String findErrorSolution(@NotNull PyExecutionException e, @Nullable String cause, @Nullable Sdk sdk) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(20);
        }
        if (cause != null && StringUtil.containsIgnoreCase((String)cause, (String)"SyntaxError")) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            return PySdkBundle.message("python.sdk.use.python.version.supported.by.this.package", new Object[]{languageLevel});
        }
        if (SystemInfo.isLinux && (PyPackageManagementService.containsInOutput(e, "pyconfig.h") || PyPackageManagementService.containsInOutput(e, "Python.h"))) {
            return PySdkBundle.message("python.sdk.check.python.development.packages.installed", new Object[0]);
        }
        if ("pip".equals(e.getCommand()) && sdk != null) {
            return PySdkBundle.message("python.sdk.try.to.run.command.from.system.terminal", sdk.getHomePath());
        }
        return null;
    }

    private static boolean containsInOutput(@NotNull PyExecutionException e, @NotNull String text2) {
        if (e == null) {
            PyPackageManagementService.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(22);
        }
        return StringUtil.containsIgnoreCase((String)e.getStdout(), (String)text2) || StringUtil.containsIgnoreCase((String)e.getStderr(), (String)text2);
    }

    @Nullable
    private static String findErrorCause(@NotNull String output) {
        Matcher m;
        if (output == null) {
            PyPackageManagementService.$$$reportNull$$$0(23);
        }
        if ((m = PATTERN_ERROR_LINE.matcher(output)).find()) {
            String result = m.group();
            return result != null ? result.trim() : null;
        }
        return null;
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            PyPackageManagementService.$$$reportNull$$$0(24);
        }
        if (listener2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(25);
        }
        this.installPackage(new RepoPackage(installedPackage.getName(), null), version, true, null, listener2, false);
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<? super String, ? super Exception> consumer) {
        if (pkg == null) {
            PyPackageManagementService.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            PyPackageManagementService.$$$reportNull$$$0(27);
        }
        this.myExecutorService.execute(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                PyPIPackageUtil.INSTANCE.loadPackages();
                String version = PyPIPackageUtil.INSTANCE.fetchLatestPackageVersion(this.myProject, pkg.getName());
                consumer.consume((Object)StringUtil.notNullize((String)version));
            }
            catch (IOException e) {
                consumer.consume((Throwable)e);
            }
        });
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PyPackageManagementService.$$$reportNull$$$0(28);
        }
        if (version2 == null) {
            PyPackageManagementService.$$$reportNull$$$0(29);
        }
        return PyPackageVersionComparator.getSTR_COMPARATOR().compare(version1, version2);
    }

    @Nullable
    public String getID() {
        return "Python";
    }

    public boolean canManageRepositories() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 13: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlStylePrefix";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPyPIPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallToUserText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackagesList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "composeHref";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installPackage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPackages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDetails";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatPackageInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findErrorSolution";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsInOutput";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findErrorCause";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyPackageInstallationErrorDescription
    extends PackageManagementService.ErrorDescription {
        @Nullable
        private final String myPackageName;
        @Nullable
        private final String myPythonVersion;
        @Nullable
        private final String myInterpreterPath;
        @Nullable
        private final Sdk mySdk;

        public PyPackageInstallationErrorDescription(@NotNull @NlsContexts.DetailedDescription String message, @Nullable String command, @Nullable String output, @Nullable @NlsContexts.DetailedDescription String solution, @Nullable String packageName, @Nullable Sdk sdk) {
            if (message == null) {
                PyPackageInstallationErrorDescription.$$$reportNull$$$0(0);
            }
            super(message, command, output, solution);
            this.myPackageName = packageName;
            this.mySdk = sdk;
            this.myPythonVersion = sdk != null ? sdk.getVersionString() : null;
            this.myInterpreterPath = sdk != null ? sdk.getHomePath() : null;
        }

        @Nullable
        public static PyPackageInstallationErrorDescription createFromMessage(@Nullable @NlsContexts.DetailedDescription String message) {
            return message != null ? new PyPackageInstallationErrorDescription(message, null, null, null, null, null) : null;
        }

        @Nullable
        @NlsSafe
        public String getPackageName() {
            return this.myPackageName;
        }

        @Nullable
        @NlsSafe
        public String getPythonVersion() {
            return this.myPythonVersion;
        }

        @Nullable
        @NlsSafe
        public String getInterpreterPath() {
            return this.myInterpreterPath;
        }

        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/packaging/ui/PyPackageManagementService$PyPackageInstallationErrorDescription", "<init>"));
        }
    }
}

