/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyBunch<MType> {
    protected Maybe<MType> myGetter;
    protected Maybe<MType> mySetter;
    protected Maybe<MType> myDeleter;
    protected String myDoc;
    protected PyTargetExpression mySite;

    @NotNull
    public Maybe<MType> getGetter() {
        Maybe<MType> maybe = this.myGetter;
        if (maybe == null) {
            PropertyBunch.$$$reportNull$$$0(0);
        }
        return maybe;
    }

    @NotNull
    public Maybe<MType> getSetter() {
        Maybe<MType> maybe = this.mySetter;
        if (maybe == null) {
            PropertyBunch.$$$reportNull$$$0(1);
        }
        return maybe;
    }

    @NotNull
    public Maybe<MType> getDeleter() {
        Maybe<MType> maybe = this.myDeleter;
        if (maybe == null) {
            PropertyBunch.$$$reportNull$$$0(2);
        }
        return maybe;
    }

    @Nullable
    public String getDoc() {
        return this.myDoc;
    }

    @NotNull
    protected abstract Maybe<MType> translate(@Nullable PyExpression var1);

    @Nullable
    public static PyCallExpression findPropertyCallSite(@Nullable PyExpression source) {
        PyReferenceExpression ref;
        PyCallExpression call;
        PyExpression callee;
        if (source instanceof PyCallExpression && (callee = (call = (PyCallExpression)source).getCallee()) instanceof PyReferenceExpression && !(ref = (PyReferenceExpression)callee).isQualified() && "property".equals(callee.getName()) && (PropertyBunch.isBuiltinFile(source.getContainingFile()) || PyResolveUtil.resolveLocally(ref).stream().allMatch(Objects::isNull))) {
            return call;
        }
        return null;
    }

    private static boolean isBuiltinFile(@NotNull PsiFile file) {
        String name2;
        if (file == null) {
            PropertyBunch.$$$reportNull$$$0(3);
        }
        return "__builtin__.py".equals(name2 = file.getName()) || "builtins.py".equals(name2);
    }

    protected static <MType> boolean fillFromCall(PyExpression source, PropertyBunch<MType> target) {
        PyArgumentList arglist;
        PyCallExpression call = PropertyBunch.findPropertyCallSite(source);
        if (call != null && (arglist = call.getArgumentList()) != null) {
            PyExpression[] accessors = new PyExpression[3];
            String doc = null;
            int position = 0;
            Object[] keywords = new String[]{"fget", "fset", "fdel", "doc"};
            for (PyExpression arg : arglist.getArguments()) {
                int index = -1;
                if (arg instanceof PyKeywordArgument) {
                    String keyword = ((PyKeywordArgument)arg).getKeyword();
                    index = ArrayUtil.indexOf((Object[])keywords, (Object)keyword);
                    if (index < 0) continue;
                    position = -1;
                } else if (position >= 0) {
                    index = position++;
                }
                if (index < 0) continue;
                arg = PyUtil.peelArgument(arg);
                if (index < 3) {
                    accessors[index] = arg;
                    continue;
                }
                if (index != 3 || !(arg instanceof PyStringLiteralExpression)) continue;
                doc = ((PyStringLiteralExpression)arg).getStringValue();
            }
            target.myGetter = target.translate(accessors[0]);
            target.mySetter = target.translate(accessors[1]);
            target.myDeleter = target.translate(accessors[2]);
            target.myDoc = doc;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PropertyBunch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PropertyBunch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltinFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

