/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyImportStatementStub;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportStatementImpl
extends PyBaseElementImpl<PyImportStatementStub>
implements PyImportStatement {
    public PyImportStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyImportStatementImpl(PyImportStatementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.IMPORT_STATEMENT);
    }

    public PyImportStatementImpl(PyImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public PyImportElement @NotNull [] getImportElements() {
        PyImportStatementStub stub = (PyImportStatementStub)this.getStub();
        if (stub != null) {
            PyImportElement[] pyImportElementArray = (PyImportElement[])stub.getChildrenByType((IElementType)PyElementTypes.IMPORT_ELEMENT, PyImportElement[]::new);
            if (pyImportElementArray == null) {
                PyImportStatementImpl.$$$reportNull$$$0(0);
            }
            return pyImportElementArray;
        }
        PyImportElement[] pyImportElementArray = (PyImportElement[])this.childrenToPsi(TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.IMPORT_ELEMENT}), new PyImportElement[0]);
        if (pyImportElementArray == null) {
            PyImportStatementImpl.$$$reportNull$$$0(1);
        }
        return pyImportElementArray;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyImportStatement(this);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PyImportStatementImpl.$$$reportNull$$$0(2);
        }
        if (ArrayUtil.contains((Object)child.getPsi(), (Object[])this.getImportElements())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, child.getPsi());
        }
        super.deleteChildInternal(child);
    }

    @Override
    @NotNull
    public List<String> getFullyQualifiedObjectNames() {
        return PyImportStatementImpl.getImportElementNames(this.getImportElements());
    }

    @NotNull
    public static List<String> getImportElementNames(PyImportElement ... elements) {
        if (elements == null) {
            PyImportStatementImpl.$$$reportNull$$$0(3);
        }
        ArrayList<String> result = new ArrayList<String>(elements.length);
        for (PyImportElement element : elements) {
            QualifiedName qName = element.getImportedQName();
            if (qName == null) continue;
            result.add(qName.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyImportStatementImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyElement resolved = PyUtil.as(this.resolveImplicitSubModule(), PyElement.class);
        ImmutableList immutableList = resolved != null ? ImmutableList.of((Object)resolved) : Collections.emptyList();
        if (immutableList == null) {
            PyImportStatementImpl.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name2) {
        PyImportElement element;
        QualifiedName importedQName;
        PyImportElement[] elements;
        if (name2 == null) {
            PyImportStatementImpl.$$$reportNull$$$0(6);
        }
        if ((elements = this.getImportElements()).length == 1 && (importedQName = (element = elements[0]).getImportedQName()) != null && importedQName.getComponentCount() > 1 && name2.equals(importedQName.getLastComponent())) {
            List<RatedResolveResult> list = ResolveResultList.to(this.resolveImplicitSubModule());
            if (list == null) {
                PyImportStatementImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyImportStatementImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private PsiElement resolveImplicitSubModule() {
        PyImportElement[] elements = this.getImportElements();
        if (elements.length == 1) {
            QualifiedName packageQName;
            PsiElement resolvedImport;
            PyImportElement element = elements[0];
            QualifiedName importedQName = element.getImportedQName();
            PsiFile file = element.getContainingFile();
            if (file != null && importedQName != null && importedQName.getComponentCount() > 1 && PyUtil.isPackage(file) && (resolvedImport = PyUtil.turnDirIntoInit(ResolveImportUtil.resolveImportElement(element, packageQName = importedQName.removeLastComponent()))) == file) {
                return element.resolve();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyImportStatementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportElements";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyImportStatementImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportElementNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImportElementNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

