/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.actions.PyRunFileInConsoleAction;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonConsoleScripts;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonModuleExecution;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonScriptCommandLineState
extends PythonCommandLineState {
    private static final String INPUT_FILE_MESSAGE = "Input is being redirected from ";
    private final PythonRunConfiguration myConfig;

    public PythonScriptCommandLineState(PythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    @Nullable
    public ExecutionResult execute(Executor executor, PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        Project project = this.myConfig.getProject();
        if (this.myConfig.showCommandLineAfterwards() && !this.emulateTerminal()) {
            if (!"Debug".equals(executor.getId()) && !"Run".equals(executor.getId())) {
                return super.execute(executor, processStarter, patchers2);
            }
            PyRunFileInConsoleAction.configExecuted(this.myConfig);
            if ("Debug".equals(executor.getId())) {
                return super.execute(executor, processStarter, (CommandLinePatcher[])ArrayUtil.append((Object[])patchers2, (Object)new CommandLinePatcher(){

                    @Override
                    public void patchCommandLine(GeneralCommandLine commandLine) {
                        commandLine.getParametersList().getParamsGroup("Debugger").addParameterAt(1, "--cmd-line");
                    }
                }));
            }
            String runFileText = PythonConsoleScripts.buildScriptWithConsoleRun(this.myConfig);
            boolean useExistingConsole = PyConsoleOptions.getInstance(project).isUseExistingConsole();
            ApplicationManager.getApplication().invokeLater(() -> PyExecuteInConsole.executeCodeInConsole(project, runFileText, null, useExistingConsole, false, true, this.myConfig));
            return null;
        }
        if (this.emulateTerminal()) {
            this.setRunWithPty(true);
            ProcessHandler processHandler = this.startProcess(processStarter, patchers2);
            TerminalExecutionConsole executeConsole = PythonScriptCommandLineState.createTerminalExecutionConsole(this.myConfig.getProject(), processHandler);
            processHandler.startNotify();
            return new DefaultExecutionResult((ExecutionConsole)executeConsole, processHandler, AnAction.EMPTY_ARRAY);
        }
        ExecutionResult executionResult = super.execute(executor, processStarter, patchers2);
        if (this.myConfig.isRedirectInput()) {
            this.addInputRedirectionMessage(project, executionResult);
        }
        return executionResult;
    }

    @Override
    @Nullable
    public ExecutionResult execute(@NotNull Executor executor, @NotNull PythonScriptTargetedCommandLineBuilder converter) throws ExecutionException {
        if (executor == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(1);
        }
        Project project = this.myConfig.getProject();
        if (this.showCommandLineAfterwards()) {
            if ("Run".equals(executor.getId())) {
                PyRunFileInConsoleAction.configExecuted(this.myConfig);
                Function<TargetEnvironment, String> runFileText = PythonConsoleScripts.buildScriptFunctionWithConsoleRun(this.myConfig);
                boolean useExistingConsole = PyConsoleOptions.getInstance(project).isUseExistingConsole();
                PyExecuteInConsole.executeCodeInConsole(project, runFileText, null, useExistingConsole, false, true, this.myConfig);
                return null;
            }
            if ("Debug".equals(executor.getId())) {
                PyRunFileInConsoleAction.configExecuted(this.myConfig);
            }
            return super.execute(executor, converter);
        }
        if (this.emulateTerminal()) {
            this.setRunWithPty(true);
            ProcessHandler processHandler = this.startProcess(converter);
            TerminalExecutionConsole executeConsole = PythonScriptCommandLineState.createTerminalExecutionConsole(project, processHandler);
            processHandler.startNotify();
            return new DefaultExecutionResult((ExecutionConsole)executeConsole, processHandler, AnAction.EMPTY_ARRAY);
        }
        ExecutionResult executionResult = super.execute(executor, converter);
        if (this.myConfig.isRedirectInput()) {
            this.addInputRedirectionMessage(project, executionResult);
        }
        return executionResult;
    }

    @NotNull
    private static TerminalExecutionConsole createTerminalExecutionConsole(@NotNull Project project, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(3);
        }
        TerminalExecutionConsole executeConsole = new TerminalExecutionConsole(project, processHandler);
        executeConsole.addMessageFilter((Filter)new PythonTracebackFilter(project));
        executeConsole.addMessageFilter((Filter)new UrlFilter());
        TerminalExecutionConsole terminalExecutionConsole = executeConsole;
        if (terminalExecutionConsole == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(4);
        }
        return terminalExecutionConsole;
    }

    private void addInputRedirectionMessage(final @NotNull Project project, @NotNull ExecutionResult executionResult) {
        if (project == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(5);
        }
        if (executionResult == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(6);
        }
        final String filePath = FileUtil.toSystemDependentName((String)new File(this.myConfig.getInputFile()).getAbsolutePath());
        final ProcessHandler processHandler = executionResult.getProcessHandler();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                processHandler.notifyTextAvailable(PythonScriptCommandLineState.INPUT_FILE_MESSAGE + filePath + "\n", ProcessOutputTypes.SYSTEM);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                processHandler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/python/run/PythonScriptCommandLineState$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExecutionConsole console = executionResult.getExecutionConsole();
        if (console instanceof ConsoleView) {
            ((ConsoleView)console).addMessageFilter(new Filter(){

                @Nullable
                public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
                    int position;
                    if (line2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((position = line2.indexOf(PythonScriptCommandLineState.INPUT_FILE_MESSAGE)) >= 0) {
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(filePath));
                        if (file == null) {
                            return null;
                        }
                        return new Filter.Result(entireLength - filePath.length() - 1, entireLength, (HyperlinkInfo)new OpenFileHyperlinkInfo(new OpenFileDescriptor(project, file)));
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/python/run/PythonScriptCommandLineState$3", "applyFilter"));
                }
            });
        }
    }

    public final boolean showCommandLineAfterwards() {
        return this.myConfig.showCommandLineAfterwards() && !this.emulateTerminal();
    }

    private boolean emulateTerminal() {
        return this.myConfig.emulateTerminal() && !PythonSdkUtil.isRemote(this.getSdk());
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        if (this.emulateTerminal() && !SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
    }

    @Override
    protected void customizePythonExecutionEnvironmentVars(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (helpersAwareTargetRequest == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(7);
        }
        if (envs == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(8);
        }
        super.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, envs, passParentEnvs);
        if (this.emulateTerminal() && !SystemInfo.isWindows) {
            envs.put("TERM", TargetEnvironmentFunctions.constant((Object)"xterm-256color"));
        }
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        if (this.emulateTerminal()) {
            return new OSProcessHandler(commandLine){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    return new BaseOutputReader.Options(){

                        public BaseDataReader.SleepingPolicy policy() {
                            return BaseDataReader.SleepingPolicy.BLOCKING;
                        }

                        public boolean splitToLines() {
                            return false;
                        }
                    };
                }
            };
        }
        return super.doCreateProcess(commandLine);
    }

    @Override
    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull Process process2, @NotNull String commandLineString, @NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine commandLine) {
        if (process2 == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(9);
        }
        if (commandLineString == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(10);
        }
        if (targetEnvironment == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(12);
        }
        if (this.emulateTerminal()) {
            return new OSProcessHandler(process2, commandLineString, commandLine.getCharset()){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    return new BaseOutputReader.Options(){

                        public BaseDataReader.SleepingPolicy policy() {
                            return BaseDataReader.SleepingPolicy.BLOCKING;
                        }

                        public boolean splitToLines() {
                            return false;
                        }
                    };
                }
            };
        }
        ProcessHandler processHandler = super.createProcessHandler(process2, commandLineString, targetEnvironment, commandLine);
        if (processHandler == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(13);
        }
        return processHandler;
    }

    @Override
    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareRequest) {
        PythonExecution pythonExecution;
        if (helpersAwareRequest == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(14);
        }
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareRequest.getTargetEnvironmentRequest();
        if (this.myConfig.isModuleMode()) {
            PythonModuleExecution moduleExecution = new PythonModuleExecution();
            String moduleName = this.myConfig.getScriptName();
            if (!StringUtil.isEmptyOrSpaces((String)moduleName)) {
                moduleExecution.setModuleName(moduleName);
            }
            pythonExecution = moduleExecution;
        } else {
            PythonScriptExecution pythonScriptExecution = new PythonScriptExecution();
            String scriptPath = this.myConfig.getScriptName();
            if (!StringUtil.isEmptyOrSpaces((String)scriptPath)) {
                pythonScriptExecution.setPythonScriptPath(this.getTargetPath(targetEnvironmentRequest, Path.of(scriptPath, new String[0])));
            }
            pythonExecution = pythonScriptExecution;
        }
        pythonExecution.addParameters(PythonScriptCommandLineState.getExpandedScriptParameters(this.myConfig));
        pythonExecution.setCharset(EncodingProjectManager.getInstance((Project)this.myConfig.getProject()).getDefaultCharset());
        PythonExecution pythonExecution2 = pythonExecution;
        if (pythonExecution2 == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(15);
        }
        return pythonExecution2;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        if (this.myConfig.isModuleMode()) {
            ParamsGroup moduleParameters = parametersList.getParamsGroup("Module");
            assert (moduleParameters != null);
            moduleParameters.addParameter("-m");
            moduleParameters.addParameters(new String[]{this.myConfig.getScriptName()});
        } else if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getScriptName())) {
            scriptParameters.addParameter(this.myConfig.getScriptName());
        }
        scriptParameters.addParameters(PythonScriptCommandLineState.getExpandedScriptParameters(this.myConfig));
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
        String inputFile = this.myConfig.getInputFile();
        if (this.myConfig.isRedirectInput() && !StringUtil.isEmptyOrSpaces((String)inputFile)) {
            commandLine.withInput(new File(inputFile));
        }
    }

    @Override
    @NotNull
    protected Function<TargetEnvironment, String> getTargetPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Path scriptPath) {
        if (targetEnvironmentRequest == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(16);
        }
        if (scriptPath == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(17);
        }
        Function<TargetEnvironment, String> function = PySdkTargetPaths.getTargetPathForPythonConsoleExecution(this.myConfig.getProject(), this.myConfig.getSdk(), this.createRemotePathMapper(), scriptPath);
        if (function == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(18);
        }
        return function;
    }

    @NotNull
    private static List<String> getExpandedScriptParameters(@NotNull PythonRunConfiguration config) {
        if (config == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(19);
        }
        String parameters = config.getScriptParameters();
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)parameters);
        if (list == null) {
            PythonScriptCommandLineState.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonScriptCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineString";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareRequest";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonScriptCommandLineState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalExecutionConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecution";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedScriptParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalExecutionConsole";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInputRedirectionMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedScriptParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

