/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.sdk.PyRemoteSdkAdditionalDataMarker;
import com.jetbrains.python.sdk.PyRemoteSdkValidator;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkUtil {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;
    static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    private static final String[] DIRS_WITH_BINARY = new String[]{"", "bin", "Scripts", "net45"};
    private static final String[] UNIX_BINARY_NAMES = new String[]{"jython", "pypy", "python", "python3"};
    private static final String[] WIN_BINARY_NAMES = new String[]{"jython.bat", "ipy.exe", "pypy.exe", "python.exe", "python3.exe"};
    private static final Predicate<Sdk> REMOTE_SDK_PREDICATE = PythonSdkUtil::isRemote;

    public static boolean isPythonSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(0);
        }
        return "Python SDK".equals(sdk.getSdkType().getName());
    }

    public static List<Sdk> getAllSdks() {
        return ContainerUtil.filter((Object[])ProjectJdkTable.getInstance().getAllJdks(), PythonSdkUtil::isPythonSdk);
    }

    @Nullable
    private static PySkeletonHeader readSkeletonHeader(@NotNull VirtualFile file, @NotNull Sdk pythonSdk2) {
        VirtualFile skeletonsDir;
        if (file == null) {
            PythonSdkUtil.$$$reportNull$$$0(1);
        }
        if (pythonSdk2 == null) {
            PythonSdkUtil.$$$reportNull$$$0(2);
        }
        if ((skeletonsDir = PythonSdkUtil.findSkeletonsDir(pythonSdk2)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)file, (boolean)false)) {
            return PySkeletonHeader.readSkeletonHeader(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return null;
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk2) {
        if (vFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(3);
        }
        if (pythonSdk2 != null) {
            VirtualFile libDir;
            @Nullable VirtualFile originFile = vFile;
            @NotNull String originPath = vFile.getPath();
            boolean checkOnRemoteFS = false;
            PySkeletonHeader header = PythonSdkUtil.readSkeletonHeader(originFile, pythonSdk2);
            if (header != null) {
                if (ApplicationManager.getApplication().isUnitTestMode() && Objects.equals(vFile.getParent(), PythonSdkUtil.findSkeletonsDir(pythonSdk2))) {
                    return true;
                }
                String binaryPath = header.getBinaryFile();
                if (binaryPath.equals("(built-in)") || binaryPath.equals("(pre-generated)")) {
                    return true;
                }
                if (PythonSdkUtil.isRemote(pythonSdk2)) {
                    checkOnRemoteFS = true;
                    originFile = null;
                } else {
                    originFile = VfsUtil.findFileByIoFile((File)new File(binaryPath), (boolean)true);
                }
                originPath = binaryPath;
            }
            if (originFile != null) {
                originFile = (VirtualFile)ObjectUtils.notNull((Object)originFile.getCanonicalFile(), (Object)originFile);
                originPath = originFile.getPath();
            }
            if ((libDir = PySearchUtilBase.findLibDir(pythonSdk2)) != null && PythonSdkUtil.isUnderLibDirButNotSitePackages(originFile, originPath, libDir, pythonSdk2, checkOnRemoteFS)) {
                return true;
            }
            VirtualFile venvLibDir = PySearchUtilBase.findVirtualEnvLibDir(pythonSdk2);
            if (venvLibDir != null && PythonSdkUtil.isUnderLibDirButNotSitePackages(originFile, originPath, venvLibDir, pythonSdk2, checkOnRemoteFS)) {
                return true;
            }
            if (PyUserSkeletonsUtil.isStandardLibrarySkeleton(vFile)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile) && PyTypeShed.INSTANCE.isInside(vFile)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk)) {
            return sdk;
        }
        return PyModuleService.getInstance().findPythonSdk(module);
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataMarker;
    }

    @NlsSafe
    public static String getUserSite() {
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            return appdata + File.separator + "Python";
        }
        String userHome = SystemProperties.getUserHome();
        return userHome + File.separator + ".local";
    }

    public static boolean isFileInSkeletons(@NotNull VirtualFile virtualFile, @NotNull Sdk sdk) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PythonSdkUtil.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(5);
        }
        return (skeletonsDir = PythonSdkUtil.findSkeletonsDir(sdk)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    public static boolean isElementInSkeletons(@NotNull PsiElement element) {
        Sdk sdk;
        VirtualFile virtualFile;
        PsiFile file;
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(6);
        }
        return (file = element.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null && (sdk = PythonSdkUtil.findPythonSdk(element)) != null && PythonSdkUtil.isFileInSkeletons(virtualFile, sdk);
    }

    @NotNull
    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        String string = PythonSdkUtil.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getSkeletonsPath(@NotNull Sdk sdk) {
        String path2;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(8);
        }
        return (path2 = sdk.getHomePath()) != null ? PythonSdkUtil.getSkeletonsPath(PathManager.getSystemPath(), path2) : null;
    }

    @NotNull
    public static String getSkeletonsRootPath(String basePath) {
        String string = basePath + File.separator + SKELETON_DIR_NAME;
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findSkeletonsDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(10);
        }
        return PythonSdkUtil.findLibraryDir(sdk, SKELETON_DIR_NAME, BUILTIN_ROOT_TYPE);
    }

    @Nullable
    public static VirtualFile findAnyRemoteLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(11);
        }
        return PythonSdkUtil.findLibraryDir(sdk, REMOTE_SOURCES_DIR_NAME, OrderRootType.CLASSES);
    }

    private static VirtualFile findLibraryDir(Sdk sdk, String dirName, OrderRootType rootType) {
        VirtualFile[] virtualFiles;
        for (VirtualFile virtualFile : virtualFiles = sdk.getRootProvider().getFiles(rootType)) {
            if (!virtualFile.isValid() || !virtualFile.getPath().contains(dirName)) continue;
            return virtualFile;
        }
        return null;
    }

    @NotNull
    private static String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk) {
        if (localRoot == null) {
            PythonSdkUtil.$$$reportNull$$$0(12);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(13);
        }
        String string = PythonRuntimeService.getInstance().mapToRemote(localRoot, sdk);
        if (string == null) {
            PythonSdkUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static boolean isUnderLibDirButNotSitePackages(@Nullable VirtualFile file, @NotNull String path2, @NotNull VirtualFile libDir, @NotNull Sdk sdk, boolean checkOnRemoteFS) {
        String originLibDirPath;
        VirtualFile originLibDir;
        if (path2 == null) {
            PythonSdkUtil.$$$reportNull$$$0(15);
        }
        if (libDir == null) {
            PythonSdkUtil.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(17);
        }
        if (checkOnRemoteFS) {
            originLibDir = libDir;
            originLibDirPath = PythonSdkUtil.mapToRemote(originLibDir.getPath(), sdk);
        } else {
            originLibDir = (VirtualFile)ObjectUtils.notNull((Object)libDir.getCanonicalFile(), (Object)libDir);
            originLibDirPath = originLibDir.getPath();
        }
        if (checkOnRemoteFS || file == null) {
            String normalizedLidDirPath = FileUtil.toSystemIndependentName((String)originLibDirPath);
            String sitePackagesPath = normalizedLidDirPath + "/site-packages";
            String normalizedPath = FileUtil.toSystemIndependentName((String)path2);
            return FileUtil.startsWith((String)normalizedPath, (String)normalizedLidDirPath) && !FileUtil.startsWith((String)normalizedPath, (String)sitePackagesPath);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)originLibDir, (VirtualFile)file, (boolean)false)) {
            VirtualFile sitePackagesDir = originLibDir.findChild("site-packages");
            return sitePackagesDir == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackagesDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!PythonSdkUtil.isPythonSdk(sdk)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(18);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            return PyRemoteSdkValidator.Companion.isInvalid(sdk);
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isDisposed(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(19);
        }
        return sdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)sdk));
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkUtil.getAllSdks().stream().filter(REMOTE_SDK_PREDICATE.negate()).collect(Collectors.toList());
    }

    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        File rootFile;
        if (rootPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(20);
        }
        if ((rootFile = new File(rootPath)).isFile()) {
            return rootFile.getAbsolutePath();
        }
        for (String dir : DIRS_WITH_BINARY) {
            File subDir = StringUtil.isEmpty((String)dir) ? rootFile : new File(rootFile, dir);
            if (!subDir.isDirectory()) continue;
            for (String binaryName : PythonSdkUtil.getBinaryNames()) {
                File executable = new File(subDir, binaryName);
                if (!executable.isFile()) continue;
                return executable.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name2) {
        String resolvedPath;
        File binPath;
        File binDir;
        if (homeDirectory == null) {
            PythonSdkUtil.$$$reportNull$$$0(21);
        }
        if (name2 == null) {
            PythonSdkUtil.$$$reportNull$$$0(22);
        }
        if ((binDir = (binPath = new File(homeDirectory)).getParentFile()) == null) {
            return null;
        }
        VirtualFileSystem localVfs = StandardFileSystems.local();
        File runner = new File(binDir, name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir, "Scripts"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "Scripts"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "local"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File(binDir.getParentFile(), "local"), "bin"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        if (FileSystemUtil.isSymLink((String)homeDirectory) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectory)) != null) {
            return PythonSdkUtil.getExecutablePath(resolvedPath, name2);
        }
        runner = new File(new File("/usr", "bin"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File("/usr", "local"), "bin"), name2);
        if (runner.exists()) {
            return localVfs.extractPresentableUrl(runner.getPath());
        }
        return null;
    }

    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        File bin;
        if (binaryPath == null) {
            PythonSdkUtil.$$$reportNull$$$0(23);
        }
        if ((bin = new File(binaryPath).getParentFile()) != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkUtil.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            if (new File(root, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name2) {
        File file;
        if (SystemInfo.isWindows) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file2 = new File(parent, name2 + "." + suffix);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name2)).exists()) {
            return file;
        }
        return null;
    }

    private static String[] getBinaryNames() {
        if (SystemInfo.isUnix) {
            return UNIX_BINARY_NAMES;
        }
        return WIN_BINARY_NAMES;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkUtil.$$$reportNull$$$0(24);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkUtil.$$$reportNull$$$0(25);
        }
        return PythonSdkUtil.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Sdk findSdkByPath(@Nullable String path2) {
        if (path2 != null) {
            return PythonSdkUtil.findSdkByPath(PythonSdkUtil.getAllSdks(), path2);
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path2) {
        if (path2 != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path2, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonSdkUtil.$$$reportNull$$$0(26);
        }
        VirtualFile libDir = PythonSdkUtil.isVirtualEnv(pythonSdk2) ? PySearchUtilBase.findVirtualEnvLibDir(pythonSdk2) : PySearchUtilBase.findLibDir(pythonSdk2);
        return libDir != null ? libDir.findChild("site-packages") : null;
    }

    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(27);
        }
        String path2 = sdk.getHomePath();
        return PythonSdkUtil.isVirtualEnv(path2);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path2) {
        return path2 != null && PythonSdkUtil.getVirtualEnvRoot(path2) != null;
    }

    @Nullable
    public static VirtualFile getCondaDirectory(@NotNull Sdk sdk) {
        VirtualFile homeDirectory;
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(28);
        }
        if ((homeDirectory = sdk.getHomeDirectory()) == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return homeDirectory.getParent();
        }
        return homeDirectory.getParent().getParent();
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(29);
        }
        return PythonSdkUtil.isCondaVirtualEnv(sdk.getHomePath());
    }

    public static boolean isCondaVirtualEnv(@Nullable String sdkPath) {
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile envs = condaMeta.getParent().findChild("envs");
        return envs == null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUtil.$$$reportNull$$$0(30);
        }
        return PythonSdkUtil.isConda(sdk.getHomePath());
    }

    public static boolean isConda(@Nullable String sdkPath) {
        return PythonSdkUtil.findCondaMeta(sdkPath) != null;
    }

    public static boolean isBaseConda(@Nullable String sdkPath) {
        VirtualFile condaMeta = PythonSdkUtil.findCondaMeta(sdkPath);
        if (condaMeta == null) {
            return false;
        }
        VirtualFile parent = condaMeta.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile condaBin = parent.findChild("condabin");
        if (condaBin != null) {
            return true;
        }
        return parent.findChild("envs") != null;
    }

    @Nullable
    private static VirtualFile findCondaMeta(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return null;
        }
        VirtualFile homeDirectory = StandardFileSystems.local().findFileByPath(sdkPath);
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile parentDirectory = homeDirectory.getParent();
        if (parentDirectory == null) {
            return null;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? parentDirectory : parentDirectory.getParent();
        return condaParent != null ? condaParent.findChild("conda-meta") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsRootPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPythonSdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileInSkeletons";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isElementInSkeletons";
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSkeletonsDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnyRemoteLibrary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUnderLibDirButNotSitePackages";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCondaDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

