/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.jetbrains.extensions.ModuleExtKt;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001e2\u0006\u0010%\u001a\u00020\u0015\u001a\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001e2\u0006\u0010&\u001a\u00020\f\u001a7\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000b2\u001a\u0010,\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030-0\u0014\"\u0006\u0012\u0002\b\u00030-\u00a2\u0006\u0002\u0010.\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\"\u0018\u0010\u0011\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\"E\u0010\u0013\u001a2\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0019\u0012\u000e\b\u0001\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00170\u0014\u00a2\u0006\u0002\b\u0017*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0018\u0010\u001b\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000e\"\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001e*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u001d\u0010!\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0017*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000e\u00a8\u0006/"}, d2={"EXECUTION_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getEXECUTION_TYPE", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "INTERPRETER_TYPE", "getINTERPRETER_TYPE", "PYTHON_IMPLEMENTATION", "getPYTHON_IMPLEMENTATION", "PYTHON_VERSION", "getPYTHON_VERSION", "executionType", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getExecutionType", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Ljava/lang/String;", "interpreterType", "getInterpreterType", "modules", "", "Lcom/intellij/openapi/module/Module;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/project/Project;", "getModules", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "pythonImplementation", "getPythonImplementation", "sdks", "", "getSdks", "(Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "version", "getVersion", "getPythonSpecificInfo", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "module", "sdk", "registerPythonSpecificEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "extraFields", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "intellij.python.community.impl"})
public final class PyStatisticToolsKt {
    @NotNull
    private static final StringEventField PYTHON_VERSION = EventFields.StringValidatedByRegexp((String)"python_version", (String)"version");
    @NotNull
    private static final StringEventField PYTHON_IMPLEMENTATION = EventFields.String((String)"python_implementation", (List)CollectionsKt.listOf((Object[])new String[]{"PyPy", "Jython", "Python"}));
    @NotNull
    private static final StringEventField EXECUTION_TYPE = EventFields.String((String)"executionType", (List)CollectionsKt.listOf((Object[])new String[]{"local", "Remote_Docker", "Remote_Docker_Compose", "Remote_WSL", "Remote_null", "third_party", "Remote_SSH_Credentials", "Remote_Vagrant", "Remote_Web_Deployment", "Remote_Unknown"}));
    @NotNull
    private static final StringEventField INTERPRETER_TYPE = EventFields.String((String)"interpreterType", (List)CollectionsKt.listOf((Object[])new String[]{"pipenv", "condavenv", "virtualenv", "regular", "poetry"}));

    @NotNull
    public static final Module[] getModules(@NotNull Project $this$modules) {
        Intrinsics.checkNotNullParameter((Object)$this$modules, (String)"$this$modules");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)$this$modules);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        return moduleManager.getModules();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> getSdks(@NotNull Project $this$sdks) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sdks, (String)"$this$sdks");
        Module[] moduleArray = PyStatisticToolsKt.getModules($this$sdks);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"modules");
        Module[] $this$mapNotNull$iv = moduleArray;
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Sdk sdk;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void p1 = element$iv$iv;
            boolean bl2 = false;
            if (ModuleExtKt.getSdk((Module)p1) == null) continue;
            Sdk it$iv$iv = sdk;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<EventPair<?>> getPythonSpecificInfo(@NotNull Module module) {
        Object object;
        block3: {
            block2: {
                Sdk sdk;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                object = ModuleExtKt.getSdk(module);
                if (object == null) break block2;
                Sdk sdk2 = sdk = object;
                boolean bl = false;
                object = PyStatisticToolsKt.getPythonSpecificInfo(sdk2);
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<EventPair<?>> getPythonSpecificInfo(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        data.add(EventFields.Language.with((Object)PythonLanguage.INSTANCE));
        data.add(PYTHON_VERSION.with((Object)PyStatisticToolsKt.getVersion(sdk)));
        data.add(PYTHON_IMPLEMENTATION.with((Object)PyStatisticToolsKt.getPythonImplementation(sdk)));
        data.add(EXECUTION_TYPE.with((Object)PyStatisticToolsKt.getExecutionType(sdk)));
        data.add(INTERPRETER_TYPE.with((Object)PyStatisticToolsKt.getInterpreterType(sdk)));
        return data;
    }

    @NotNull
    public static final VarargEventId registerPythonSpecificEvent(@NotNull EventLogGroup group2, @NotNull String eventId, EventField<?> ... extraFields) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(extraFields, (String)"extraFields");
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)((EventField)EventFields.Language));
        spreadBuilder.add((Object)((EventField)PYTHON_VERSION));
        spreadBuilder.add((Object)((EventField)PYTHON_IMPLEMENTATION));
        spreadBuilder.add((Object)((EventField)EXECUTION_TYPE));
        spreadBuilder.add((Object)((EventField)INTERPRETER_TYPE));
        spreadBuilder.addSpread(extraFields);
        return group2.registerVarargEvent(eventId, (EventField[])spreadBuilder.toArray((Object[])new EventField[spreadBuilder.size()]));
    }

    @NotNull
    public static final StringEventField getPYTHON_VERSION() {
        return PYTHON_VERSION;
    }

    @NotNull
    public static final StringEventField getPYTHON_IMPLEMENTATION() {
        return PYTHON_IMPLEMENTATION;
    }

    @NotNull
    public static final StringEventField getEXECUTION_TYPE() {
        return EXECUTION_TYPE;
    }

    @NotNull
    public static final StringEventField getINTERPRETER_TYPE() {
        return INTERPRETER_TYPE;
    }

    private static final String getVersion(Sdk $this$version) {
        String string = PythonSdkType.getLanguageLevelForSdk($this$version).toPythonVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PythonSdkType.getLanguag\u2026k(this).toPythonVersion()");
        return string;
    }

    private static final String getPythonImplementation(Sdk $this$pythonImplementation) {
        Object object = PythonSdkFlavor.getFlavor($this$pythonImplementation);
        if (object == null || (object = ((PythonSdkFlavor)object).getName()) == null) {
            object = "Python";
        }
        return object;
    }

    private static final String getExecutionType(Sdk $this$executionType) {
        Object object;
        SdkAdditionalData sdkAdditionalData = $this$executionType.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase)) {
            sdkAdditionalData = null;
        }
        if ((object = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData) == null || (object = PyStatisticToolsKt.getExecutionType((PyRemoteSdkAdditionalDataBase)object)) == null) {
            object = "local";
        }
        return object;
    }

    private static final String getInterpreterType(Sdk $this$interpreterType) {
        return PipenvKt.isPipEnv($this$interpreterType) ? "pipenv" : (PoetryKt.isPoetry($this$interpreterType) ? "poetry" : (PythonSdkUtil.isConda($this$interpreterType) ? "condavenv" : (PythonSdkUtil.isVirtualEnv($this$interpreterType) ? "virtualenv" : "regular")));
    }

    private static final String getExecutionType(PyRemoteSdkAdditionalDataBase $this$executionType) {
        Object object;
        CredentialsType credentialsType;
        CredentialsType type = credentialsType = $this$executionType.getRemoteConnectionType();
        boolean bl = false;
        if (type == null) {
            object = "Remote_null";
        } else if (PluginInfoDetectorKt.getPluginInfo(type.getClass()).isDevelopedByJetBrains()) {
            String string = type.getName();
            object = "Remote_" + (string != null ? StringsKt.replace$default((String)string, (char)' ', (char)'_', (boolean)false, (int)4, null) : null);
        } else {
            object = "third_party";
        }
        return object;
    }
}

