/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository2, String branchName) throws IOException {
        String shortBranchName = Repository.shortenRefName(branchName);
        String fullBranchName = "refs/heads/" + shortBranchName;
        BranchConfig branchConfig = new BranchConfig(repository2.getConfig(), shortBranchName);
        String trackingBranch = branchConfig.getTrackingBranch();
        if (trackingBranch == null) {
            return null;
        }
        Ref tracking = repository2.exactRef(trackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local = repository2.exactRef(fullBranchName);
        if (local == null) {
            return null;
        }
        try (RevWalk walk = new RevWalk(repository2);){
            RevCommit localCommit = walk.parseCommit(local.getObjectId());
            RevCommit trackingCommit = walk.parseCommit(tracking.getObjectId());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.setRevFilter(RevFilter.ALL);
            int aheadCount = RevWalkUtils.count(walk, localCommit, mergeBase);
            int behindCount = RevWalkUtils.count(walk, trackingCommit, mergeBase);
            BranchTrackingStatus branchTrackingStatus = new BranchTrackingStatus(trackingBranch, aheadCount, behindCount);
            return branchTrackingStatus;
        }
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

