/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.util.Message;

public class StatusManager {
    private final List<Status> statuses = new ArrayList<Status>();
    private String defaultStatus;
    private Map<String, Integer> statusPriorityMap;
    private Map<String, Boolean> statusIntegrationMap;
    private String deliveryStatusListString;

    public static StatusManager newDefaultInstance() {
        return new StatusManager(new Status[]{new Status("release", false), new Status("milestone", false), new Status("integration", true)}, "integration");
    }

    public static StatusManager getCurrent() {
        return IvyContext.getContext().getSettings().getStatusManager();
    }

    public StatusManager(Status[] status2, String defaultStatus) {
        this.statuses.addAll(Arrays.asList(status2));
        this.defaultStatus = defaultStatus;
        this.computeMaps();
    }

    public StatusManager() {
    }

    public void addStatus(Status status2) {
        this.statuses.add(status2);
    }

    public void setDefaultStatus(String defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    private void computeMaps() {
        if (this.statuses.isEmpty()) {
            throw new IllegalStateException("badly configured statuses: none found");
        }
        this.statusPriorityMap = new HashMap<String, Integer>();
        for (Status status2 : this.statuses) {
            this.statusPriorityMap.put(status2.getName(), this.statuses.indexOf(status2));
        }
        this.statusIntegrationMap = new HashMap<String, Boolean>();
        for (Status status2 : this.statuses) {
            this.statusIntegrationMap.put(status2.getName(), status2.isIntegration());
        }
    }

    public boolean isStatus(String status2) {
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        return this.statusPriorityMap.containsKey(status2);
    }

    public int getPriority(String status2) {
        Integer priority;
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        if ((priority = this.statusPriorityMap.get(status2)) == null) {
            Message.debug("unknown status " + status2 + ": assuming lowest priority");
            return Integer.MAX_VALUE;
        }
        return priority;
    }

    public boolean isIntegration(String status2) {
        Boolean isIntegration;
        if (this.statusIntegrationMap == null) {
            this.computeMaps();
        }
        if ((isIntegration = this.statusIntegrationMap.get(status2)) == null) {
            Message.debug("unknown status " + status2 + ": assuming integration");
            return true;
        }
        return isIntegration;
    }

    public String getDeliveryStatusListString() {
        if (this.deliveryStatusListString == null) {
            StringBuilder ret = new StringBuilder();
            for (Status status2 : this.statuses) {
                if (status2.isIntegration()) continue;
                ret.append(status2.getName()).append(",");
            }
            if (ret.length() > 0) {
                ret.deleteCharAt(ret.length() - 1);
            }
            this.deliveryStatusListString = ret.toString();
        }
        return this.deliveryStatusListString;
    }

    public String getDefaultStatus() {
        if (this.defaultStatus == null) {
            if (this.statuses.isEmpty()) {
                throw new IllegalStateException("badly configured statuses: none found");
            }
            this.defaultStatus = this.statuses.get(this.statuses.size() - 1).getName();
        }
        return this.defaultStatus;
    }
}

