/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.CredentialsUtil;
import org.apache.ivy.util.Message;

public final class SshCache {
    private static final int SSH_DEFAULT_PORT = 22;
    private static SshCache instance = new SshCache();
    private final Map<String, Entry> uriCacheMap = new HashMap<String, Entry>();
    private final Map<Session, Entry> sessionCacheMap = new HashMap<Session, Entry>();

    private SshCache() {
    }

    public static SshCache getInstance() {
        return instance;
    }

    private Entry getCacheEntry(String user, String host, int port) {
        return this.uriCacheMap.get(SshCache.createCacheKey(user, host, port));
    }

    private static String createCacheKey(String user, String host, int port) {
        String portToUse = "22";
        if (port != -1 && port != 22) {
            portToUse = Integer.toString(port);
        }
        return user.trim().toLowerCase(Locale.US) + "@" + host.trim().toLowerCase(Locale.US) + ":" + portToUse;
    }

    private Entry getCacheEntry(Session session) {
        return this.sessionCacheMap.get(session);
    }

    private void setSession(String user, String host, int port, Session newSession) {
        Entry entry = this.uriCacheMap.get(SshCache.createCacheKey(user, host, port));
        Session oldSession = null;
        if (entry != null) {
            oldSession = entry.getSession();
        }
        if (oldSession != null && !oldSession.equals(newSession) && oldSession.isConnected()) {
            entry.releaseChannelSftp();
            String oldhost = oldSession.getHost();
            Message.verbose(":: SSH :: closing ssh connection from " + oldhost + "...");
            oldSession.disconnect();
            Message.verbose(":: SSH :: ssh connection closed from " + oldhost);
        }
        if (newSession == null && entry != null) {
            this.uriCacheMap.remove(SshCache.createCacheKey(user, host, port));
            if (entry.getSession() != null) {
                this.sessionCacheMap.remove(entry.getSession());
            }
        } else {
            Entry newEntry = new Entry(newSession, user, host, port);
            this.uriCacheMap.put(SshCache.createCacheKey(user, host, port), newEntry);
            this.sessionCacheMap.put(newSession, newEntry);
        }
    }

    public void clearSession(Session session) {
        Entry entry = this.sessionCacheMap.get(session);
        if (entry != null) {
            this.setSession(entry.getUser(), entry.getHost(), entry.getPort(), null);
        }
    }

    public ChannelSftp getChannelSftp(Session session) throws IOException {
        ChannelSftp channel2 = null;
        Entry entry = this.getCacheEntry(session);
        if (entry != null && (channel2 = entry.getChannelSftp()) != null && !channel2.isConnected()) {
            entry.releaseChannelSftp();
            channel2 = null;
        }
        return channel2;
    }

    public void attachChannelSftp(Session session, ChannelSftp channel2) {
        Entry entry = this.getCacheEntry(session);
        if (entry == null) {
            throw new IllegalArgumentException("No entry for " + session + " in the cache");
        }
        entry.setChannelSftp(channel2);
    }

    private boolean attemptAgentUse(JSch jsch) {
        try {
            Connector con = ConnectorFactory.getDefault().createConnector();
            jsch.setIdentityRepository((IdentityRepository)new RemoteIdentityRepository(con));
            return true;
        }
        catch (Exception e) {
            Message.verbose(":: SSH :: Failure connecting to agent :: " + e.toString());
            return false;
        }
    }

    public Session getSession(String host, int port, String username, String userPassword, File pemFile, String pemPassword, File passFile, boolean allowedAgentUse) throws IOException {
        Checks.checkNotNull(host, "host");
        Checks.checkNotNull(username, "user");
        Entry entry = this.getCacheEntry(username, host, port);
        Session session = null;
        if (entry != null) {
            session = entry.getSession();
        }
        if (session == null || !session.isConnected()) {
            Message.verbose(":: SSH :: connecting to " + host + "...");
            try {
                JSch jsch = new JSch();
                session = port != -1 ? jsch.getSession(username, host, port) : jsch.getSession(username, host);
                if (allowedAgentUse) {
                    this.attemptAgentUse(jsch);
                }
                if (pemFile != null) {
                    jsch.addIdentity(pemFile.getAbsolutePath(), pemPassword);
                }
                session.setUserInfo((UserInfo)new CfUserInfo(host, username, userPassword, pemFile, pemPassword, passFile));
                session.setDaemonThread(true);
                Properties config2 = new Properties();
                config2.setProperty("PreferredAuthentications", "publickey,keyboard-interactive,password");
                session.setConfig(config2);
                session.connect();
                Message.verbose(":: SSH :: connected to " + host + "!");
                this.setSession(username, host, port, session);
            }
            catch (JSchException e) {
                if (passFile != null && passFile.exists()) {
                    passFile.delete();
                }
                throw new IOException(e.getMessage(), e);
            }
        }
        return session;
    }

    private static class CfUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String userPassword;
        private String pemPassword;
        private String userName;
        private final File pemFile;
        private final String host;
        private final File passfile;

        public CfUserInfo(String host, String userName, String userPassword, File pemFile, String pemPassword, File passfile) {
            this.userPassword = userPassword;
            this.pemPassword = pemPassword;
            this.host = host;
            this.passfile = passfile;
            this.userName = userName;
            this.pemFile = pemFile;
        }

        public void showMessage(String message2) {
            Message.info(message2);
        }

        public boolean promptYesNo(String message2) {
            return true;
        }

        public boolean promptPassword(String message2) {
            return true;
        }

        public boolean promptPassphrase(String message2) {
            return true;
        }

        public String getPassword() {
            Credentials c;
            if (this.userPassword == null && (c = CredentialsUtil.promptCredentials(new Credentials(null, this.host, this.userName, this.userPassword), this.passfile)) != null) {
                this.userName = c.getUserName();
                this.userPassword = c.getPasswd();
            }
            return this.userPassword;
        }

        public String getPassphrase() {
            Credentials c;
            if (this.pemPassword == null && this.pemFile != null && (c = CredentialsUtil.promptCredentials(new Credentials(null, this.pemFile.getAbsolutePath(), this.userName, this.pemPassword), this.passfile)) != null) {
                this.userName = c.getUserName();
                this.pemPassword = c.getPasswd();
            }
            return this.pemPassword;
        }

        public String[] promptKeyboardInteractive(String destination, String name2, String instruction, String[] prompt, boolean[] echo) {
            return new String[]{this.getPassword()};
        }
    }

    private class Entry {
        private Session session = null;
        private ChannelSftp channelSftp = null;
        private String host = null;
        private String user = null;
        private int port = 22;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public Entry(Session newSession, String newUser, String newHost, int newPort) {
            this.session = newSession;
            this.host = newHost;
            this.user = newUser;
            this.port = newPort;
            IvyContext.getContext().getEventManager().addIvyListener(new IvyListener(){

                @Override
                public void progress(IvyEvent event2) {
                    event2.getSource().removeIvyListener(this);
                    SshCache.this.clearSession(Entry.this.session);
                }
            }, "post-resolve");
        }

        public void setChannelSftp(ChannelSftp newChannel) {
            if (this.channelSftp != null && newChannel != null) {
                throw new IllegalStateException("Only one sftp channelSftp per session allowed");
            }
            this.channelSftp = newChannel;
        }

        public ChannelSftp getChannelSftp() {
            return this.channelSftp;
        }

        private Session getSession() {
            return this.session;
        }

        public void releaseChannelSftp() {
            if (this.channelSftp != null && this.channelSftp.isConnected()) {
                Message.verbose(":: SFTP :: closing sftp connection from " + this.host + "...");
                this.channelSftp.disconnect();
                this.channelSftp = null;
                Message.verbose(":: SFTP :: sftp connection closed from " + this.host);
            }
        }
    }
}

