/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import runtime.container.ConstructorBinding;
import runtime.container.InvalidDependencyArityException;
import runtime.container.MethodBinding;
import runtime.container.UnresolvedDependenciesException;
import runtime.container.ValueDescriptor;
import runtime.container.ValueResolveContext;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\r\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u000e2\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001\u00a8\u0006\u000f"}, d2={"bindArguments", "", "", "argumentDescriptors", "Lruntime/container/ValueDescriptor;", "bindToConstructor", "Lruntime/container/ConstructorBinding;", "Ljava/lang/Class;", "context", "Lruntime/container/ValueResolveContext;", "bindToMethod", "Lruntime/container/MethodBinding;", "Ljava/lang/reflect/Method;", "createInstance", "Ljava/lang/reflect/Constructor;", "platform-runtime"})
public final class ResolveKt {
    @NotNull
    public static final Object createInstance(@NotNull Constructor<?> $this$createInstance, @NotNull List<? extends ValueDescriptor> argumentDescriptors) {
        Intrinsics.checkNotNullParameter($this$createInstance, (String)"<this>");
        Intrinsics.checkNotNullParameter(argumentDescriptors, (String)"argumentDescriptors");
        Object[] objectArray = new Object[]{ResolveKt.bindArguments(argumentDescriptors)};
        Object obj = $this$createInstance.newInstance(objectArray);
        Intrinsics.checkNotNull(obj);
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> bindArguments(@NotNull List<? extends ValueDescriptor> argumentDescriptors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(argumentDescriptors, (String)"argumentDescriptors");
        Iterable $this$map$iv = argumentDescriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 == null ? null : v0.getValue());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ConstructorBinding bindToConstructor(@NotNull Class<?> $this$bindToConstructor, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter($this$bindToConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KClass kClass = JvmClassMappingKt.getKotlinClass($this$bindToConstructor);
        if (kClass.getConstructors().size() != 1) {
            StringBuilder stringBuilder = new StringBuilder().append("Class ").append($this$bindToConstructor).append(" is expected to have a single constructor but has: \n");
            Constructor<?>[] constructorArray = $this$bindToConstructor.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"constructors");
            throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])constructorArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString().toString());
        }
        KFunction candidate = (KFunction)CollectionsKt.single((Iterable)kClass.getConstructors());
        List parameters2 = candidate.getParameters();
        ArrayList<ValueDescriptor> arguments = new ArrayList<ValueDescriptor>(parameters2.size());
        List unsatisfied = null;
        for (KParameter parameter2 : parameters2) {
            ValueDescriptor valueDescriptor;
            try {
                valueDescriptor = context2.resolve(ReflectJvmMapping.getJavaType((KType)parameter2.getType()));
            }
            catch (InvalidDependencyArityException ex) {
                throw new UnresolvedDependenciesException("Unable to create instance of type [" + $this$bindToConstructor + "]. Constructor parameter of type [" + parameter2 + "] has invalid arity", ex);
            }
            ValueDescriptor descriptor2 = valueDescriptor;
            if (descriptor2 == null) {
                if (parameter2.getType().isMarkedNullable()) {
                    arguments.add(null);
                    continue;
                }
                if (unsatisfied == null) {
                    unsatisfied = new ArrayList();
                }
                unsatisfied.add(ReflectJvmMapping.getJavaType((KType)parameter2.getType()));
                continue;
            }
            arguments.add(descriptor2);
        }
        if (unsatisfied == null) {
            Constructor constructor = ReflectJvmMapping.getJavaConstructor((KFunction)candidate);
            Intrinsics.checkNotNull((Object)constructor);
            return new ConstructorBinding(constructor, (List<? extends ValueDescriptor>)arguments);
        }
        throw new UnresolvedDependenciesException("Dependencies for type `" + $this$bindToConstructor + "` cannot be satisfied:\n  " + unsatisfied, null, 2, null);
    }

    @NotNull
    public static final MethodBinding bindToMethod(@NotNull Method $this$bindToMethod, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$bindToMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Type[] parameters2 = $this$bindToMethod.getGenericParameterTypes();
        ArrayList<ValueDescriptor> arguments = new ArrayList<ValueDescriptor>(parameters2.length);
        List unsatisfied = null;
        Intrinsics.checkNotNullExpressionValue((Object)parameters2, (String)"parameters");
        Type[] typeArray = parameters2;
        int n = 0;
        int n2 = typeArray.length;
        while (n < n2) {
            ValueDescriptor valueDescriptor;
            Type parameter2 = typeArray[n];
            ++n;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter");
                valueDescriptor = context2.resolve(parameter2);
            }
            catch (InvalidDependencyArityException ex) {
                throw new UnresolvedDependenciesException("Unable to create instance of type " + $this$bindToMethod.getDeclaringClass() + ". Method " + $this$bindToMethod.getName() + " parameter of type " + parameter2 + " has invalid arity", null, 2, null);
            }
            ValueDescriptor descriptor2 = valueDescriptor;
            if (descriptor2 == null) {
                if (unsatisfied == null) {
                    unsatisfied = new ArrayList();
                }
                unsatisfied.add(parameter2);
                continue;
            }
            arguments.add(descriptor2);
        }
        if (unsatisfied == null) {
            return new MethodBinding($this$bindToMethod, (List<? extends ValueDescriptor>)arguments);
        }
        throw new UnresolvedDependenciesException("Dependencies for method `" + $this$bindToMethod + "` cannot be satisfied:\n  " + unsatisfied, null, 2, null);
    }
}

