/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedSetDocValuesWriter
extends DocValuesWriter<SortedSetDocValues> {
    final BytesRefHash hash;
    private final PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc = -1;
    private int[] currentValues = new int[8];
    private int currentUpto;
    private int maxCount;
    private PackedLongValues finalOrds;
    private PackedLongValues finalOrdCounts;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    SortedSetDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed, ByteBlockPool pool) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.packedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        assert (docID >= this.currentDoc);
        if (value == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= 32766");
        }
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        int i;
        if (this.currentDoc == -1) {
            return;
        }
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        int lastValue = -1;
        int count = 0;
        for (i = 0; i < this.currentUpto; ++i) {
            int termID = this.currentValues[i];
            if (termID != lastValue) {
                this.pending.add(termID);
                ++count;
            }
            lastValue = termID;
        }
        if (this.pendingCounts != null) {
            this.pendingCounts.add(count);
        } else if (count != 1) {
            this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
            for (i = 0; i < this.docsWithField.cardinality(); ++i) {
                this.pendingCounts.add(1L);
            }
            this.pendingCounts.add(count);
        }
        this.maxCount = Math.max(this.maxCount, count);
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    private void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
            this.iwBytesUsed.addAndGet((this.currentValues.length - this.currentUpto) * 4);
        }
        this.currentValues[this.currentUpto] = termID;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + (this.pendingCounts == null ? 0L : this.pendingCounts.ramBytesUsed()) + this.docsWithField.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    SortedSetDocValues getDocValues() {
        if (this.finalOrds == null) {
            assert (this.finalOrdCounts == null && this.finalSortedValues == null && this.finalOrdMap == null);
            this.finishCurrentDoc();
            int valueCount = this.hash.size();
            this.finalOrds = this.pending.build();
            this.finalOrdCounts = this.pendingCounts == null ? null : this.pendingCounts.build();
            this.finalSortedValues = this.hash.sort();
            this.finalOrdMap = new int[valueCount];
        }
        for (int ord = 0; ord < this.finalOrdMap.length; ++ord) {
            this.finalOrdMap[this.finalSortedValues[ord]] = ord;
        }
        return this.getValues(this.finalSortedValues, this.finalOrdMap, this.hash, this.finalOrds, this.finalOrdCounts, this.maxCount, this.docsWithField);
    }

    private SortedSetDocValues getValues(int[] sortedValues, int[] ordMap, BytesRefHash hash, PackedLongValues ords, PackedLongValues ordCounts, int maxCount, DocsWithFieldSet docsWithField) {
        if (ordCounts == null) {
            return DocValues.singleton(new SortedDocValuesWriter.BufferedSortedDocValues(hash, ords, sortedValues, ordMap, docsWithField.iterator()));
        }
        return new BufferedSortedSetDocValues(sortedValues, ordMap, hash, ords, ordCounts, maxCount, docsWithField.iterator());
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        int[] ordMap;
        int[] sortedValues;
        PackedLongValues ordCounts;
        PackedLongValues ords;
        int valueCount = this.hash.size();
        if (this.finalOrds == null) {
            assert (this.finalOrdCounts == null && this.finalSortedValues == null && this.finalOrdMap == null);
            this.finishCurrentDoc();
            ords = this.pending.build();
            ordCounts = this.pendingCounts == null ? null : this.pendingCounts.build();
            sortedValues = this.hash.sort();
            ordMap = new int[valueCount];
            for (int ord = 0; ord < valueCount; ++ord) {
                ordMap[sortedValues[ord]] = ord;
            }
        } else {
            ords = this.finalOrds;
            ordCounts = this.finalOrdCounts;
            sortedValues = this.finalSortedValues;
            ordMap = this.finalOrdMap;
        }
        final DocOrds docOrds = sortMap != null ? new DocOrds(state.segmentInfo.maxDoc(), sortMap, this.getValues(sortedValues, ordMap, this.hash, ords, ordCounts, this.maxCount, this.docsWithField), 7.0f, PackedInts.bitsRequired(this.maxCount)) : null;
        dvConsumer.addSortedSetField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != SortedSetDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                SortedSetDocValues buf = SortedSetDocValuesWriter.this.getValues(sortedValues, ordMap, SortedSetDocValuesWriter.this.hash, ords, ordCounts, SortedSetDocValuesWriter.this.maxCount, SortedSetDocValuesWriter.this.docsWithField);
                if (docOrds == null) {
                    return buf;
                }
                return new SortingSortedSetDocValues(buf, docOrds);
            }
        });
    }

    static final class DocOrds {
        final long[] offsets;
        final PackedLongValues ords;
        final GrowableWriter docValueCounts;
        public static final int START_BITS_PER_VALUE = 2;

        DocOrds(int maxDoc, Sorter.DocMap sortMap, SortedSetDocValues oldValues, float acceptableOverheadRatio, int bitsPerValue) throws IOException {
            int docID;
            this.offsets = new long[maxDoc];
            PackedLongValues.Builder builder = PackedLongValues.packedBuilder(acceptableOverheadRatio);
            this.docValueCounts = new GrowableWriter(bitsPerValue, maxDoc, acceptableOverheadRatio);
            long ordOffset = 1L;
            while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                long startOffset = ordOffset;
                int docValueCount = oldValues.docValueCount();
                ordOffset += (long)docValueCount;
                for (int i = 0; i < docValueCount; ++i) {
                    builder.add(oldValues.nextOrd());
                }
                this.docValueCounts.set(newDocID, ordOffset - startOffset);
                if (startOffset == ordOffset) continue;
                this.offsets[newDocID] = startOffset;
            }
            this.ords = builder.build();
        }
    }

    static class SortingSortedSetDocValues
    extends SortedSetDocValues {
        private final SortedSetDocValues in;
        private final DocOrds ords;
        private int docID = -1;
        private long ordUpto;
        private long limit;
        private int count;

        SortingSortedSetDocValues(SortedSetDocValues in, DocOrds ords) {
            this.in = in;
            this.ords = ords;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.ords.offsets.length) continue;
                this.docID = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (this.ords.offsets[this.docID] <= 0L);
            this.initCount();
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.initCount();
            return this.ords.offsets[this.docID] > 0L;
        }

        @Override
        public long nextOrd() {
            if (this.limit == this.ordUpto) {
                return -1L;
            }
            return this.ords.ords.get(this.ordUpto++);
        }

        @Override
        public int docValueCount() {
            assert (this.docID >= 0);
            return this.count;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public long getValueCount() {
            return this.in.getValueCount();
        }

        private void initCount() {
            assert (this.docID >= 0);
            this.ordUpto = this.ords.offsets[this.docID] - 1L;
            this.count = (int)this.ords.docValueCounts.get(this.docID);
            this.limit = this.ordUpto + (long)this.count;
        }
    }

    private static class BufferedSortedSetDocValues
    extends SortedSetDocValues {
        final int[] sortedValues;
        final int[] ordMap;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final PackedLongValues.Iterator ordsIter;
        final PackedLongValues.Iterator ordCountsIter;
        final DocIdSetIterator docsWithField;
        final int[] currentDoc;
        private int ordCount;
        private int ordUpto;

        BufferedSortedSetDocValues(int[] sortedValues, int[] ordMap, BytesRefHash hash, PackedLongValues ords, PackedLongValues ordCounts, int maxCount, DocIdSetIterator docsWithField) {
            this.currentDoc = new int[maxCount];
            this.sortedValues = sortedValues;
            this.ordMap = ordMap;
            this.hash = hash;
            this.ordsIter = ords.iterator();
            this.ordCountsIter = ordCounts.iterator();
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ordCount = (int)this.ordCountsIter.next();
                assert (this.ordCount > 0);
                for (int i = 0; i < this.ordCount; ++i) {
                    this.currentDoc[i] = this.ordMap[Math.toIntExact(this.ordsIter.next())];
                }
                Arrays.sort(this.currentDoc, 0, this.ordCount);
                this.ordUpto = 0;
            }
            return docID;
        }

        @Override
        public long nextOrd() {
            if (this.ordUpto == this.ordCount) {
                return -1L;
            }
            return this.currentDoc[this.ordUpto++];
        }

        @Override
        public int docValueCount() {
            return this.ordCount;
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getValueCount() {
            return this.ordMap.length;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L && ord < (long)this.ordMap.length) : "ord=" + ord + " is out of bounds 0 .. " + (this.ordMap.length - 1);
            this.hash.get(this.sortedValues[Math.toIntExact(ord)], this.scratch);
            return this.scratch;
        }
    }
}

