/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.Locale;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.InvokeClassPayload;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/node"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class InvokeClassAPI {
    public static final String INVOKE_CMD = "invoke";
    private final CoreAdminHandler coreAdminHandler;

    public InvokeClassAPI(CoreAdminHandler coreAdminHandler) {
        this.coreAdminHandler = coreAdminHandler;
    }

    @Command(name="invoke")
    public void invokeClasses(PayloadObj<InvokeClassPayload> payload) throws Exception {
        InvokeClassPayload v2Body = payload.get();
        ModifiableSolrParams v1Params = new ModifiableSolrParams(payload.getRequest().getParams());
        v1Params.add("action", new String[]{CoreAdminParams.CoreAdminAction.INVOKE.name().toLowerCase(Locale.ROOT)});
        for (String clazzStr : v2Body.classes) {
            v1Params.add("class", new String[]{clazzStr});
        }
        payload.getRequest().setParams((SolrParams)v1Params);
        this.coreAdminHandler.handleRequestBody(payload.getRequest(), payload.getResponse());
    }
}

