/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv;

import java.io.Serializable;

public class CSVStrategy
implements Cloneable,
Serializable {
    private final char delimiter;
    private final char encapsulator;
    private final char commentStart;
    private final char escape;
    private final boolean ignoreLeadingWhitespaces;
    private final boolean ignoreTrailingWhitespaces;
    private final boolean interpretUnicodeEscapes;
    private final boolean ignoreEmptyLines;
    private final String printerNewline;
    public static char COMMENTS_DISABLED = (char)65534;
    public static char ESCAPE_DISABLED = (char)65534;
    public static char ENCAPSULATOR_DISABLED = (char)65534;
    public static String DEFAULT_PRINTER_NEWLINE = "\n";
    public static final CSVStrategy DEFAULT_STRATEGY = new CSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);
    public static final CSVStrategy EXCEL_STRATEGY = new CSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, false, false, false, false, DEFAULT_PRINTER_NEWLINE);
    public static final CSVStrategy TDF_STRATEGY = new CSVStrategy('\t', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);

    public CSVStrategy(char delimiter, char encapsulator, char commentStart) {
        this(delimiter, encapsulator, commentStart, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);
    }

    public CSVStrategy(char delimiter, char encapsulator, char commentStart, char escape, boolean ignoreLeadingWhitespaces, boolean ignoreTrailingWhitespaces, boolean interpretUnicodeEscapes, boolean ignoreEmptyLines, String printerNewline) {
        this.delimiter = delimiter;
        this.encapsulator = encapsulator;
        this.commentStart = commentStart;
        this.escape = escape;
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
        this.interpretUnicodeEscapes = interpretUnicodeEscapes;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.printerNewline = printerNewline;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getEncapsulator() {
        return this.encapsulator;
    }

    public char getCommentStart() {
        return this.commentStart;
    }

    public boolean isCommentingDisabled() {
        return this.commentStart == COMMENTS_DISABLED;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public boolean getUnicodeEscapeInterpretation() {
        return this.interpretUnicodeEscapes;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public String getPrinterNewline() {
        return this.printerNewline;
    }
}

