/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetProducer;
import org.apache.solr.search.SolrIndexSearcher;

class DocSetQuery
extends Query
implements DocSetProducer {
    private final DocSet docSet;

    DocSetQuery(DocSet docSet) {
        this.docSet = Objects.requireNonNull(docSet);
    }

    public String toString(String field) {
        return "DocSetQuery(" + field + ")";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && this.equalsTo((DocSetQuery)this.getClass().cast(obj));
    }

    private boolean equalsTo(DocSetQuery other) {
        return Objects.equals(this.docSet, other.docSet);
    }

    public int hashCode() {
        return this.classHash() * 31 + this.docSet.hashCode();
    }

    @Override
    public DocSet createDocSet(SolrIndexSearcher searcher) throws IOException {
        return this.docSet;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) {
                DocIdSetIterator disi = DocSetQuery.this.docSet.iterator(context);
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, disi);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

