/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Locale;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.LuceneQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.update.processor.ClassificationUpdateProcessor;
import org.apache.solr.update.processor.ClassificationUpdateProcessorParams;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class ClassificationUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    private static final String INPUT_FIELDS_PARAM = "inputFields";
    private static final String TRAINING_CLASS_FIELD_PARAM = "classField";
    private static final String PREDICTED_CLASS_FIELD_PARAM = "predictedClassField";
    private static final String MAX_CLASSES_TO_ASSIGN_PARAM = "predictedClass.maxCount";
    private static final String ALGORITHM_PARAM = "algorithm";
    private static final String KNN_MIN_TF_PARAM = "knn.minTf";
    private static final String KNN_MIN_DF_PARAM = "knn.minDf";
    private static final String KNN_K_PARAM = "knn.k";
    private static final String KNN_FILTER_QUERY = "knn.filterQuery";
    private static final int DEFAULT_MAX_CLASSES_TO_ASSIGN = 1;
    private static final int DEFAULT_MIN_TF = 1;
    private static final int DEFAULT_MIN_DF = 1;
    private static final int DEFAULT_K = 10;
    private static final Algorithm DEFAULT_ALGORITHM = Algorithm.KNN;
    private SolrParams params;
    private ClassificationUpdateProcessorParams classificationParams;

    @Override
    public void init(NamedList<?> args) {
        if (args != null) {
            Algorithm classificationAlgorithm;
            this.params = args.toSolrParams();
            this.classificationParams = new ClassificationUpdateProcessorParams();
            String fieldNames = this.params.get(INPUT_FIELDS_PARAM);
            this.checkNotNull(INPUT_FIELDS_PARAM, fieldNames);
            this.classificationParams.setInputFieldNames(fieldNames.split("\\,"));
            String trainingClassField = this.params.get(TRAINING_CLASS_FIELD_PARAM);
            this.checkNotNull(TRAINING_CLASS_FIELD_PARAM, trainingClassField);
            this.classificationParams.setTrainingClassField(trainingClassField);
            String predictedClassField = this.params.get(PREDICTED_CLASS_FIELD_PARAM);
            if (predictedClassField == null || predictedClassField.isEmpty()) {
                predictedClassField = trainingClassField;
            }
            this.classificationParams.setPredictedClassField(predictedClassField);
            this.classificationParams.setMaxPredictedClasses(this.getIntParam(this.params, MAX_CLASSES_TO_ASSIGN_PARAM, 1));
            String algorithmString = this.params.get(ALGORITHM_PARAM);
            try {
                classificationAlgorithm = algorithmString == null || Algorithm.valueOf(algorithmString.toUpperCase(Locale.ROOT)) == null ? DEFAULT_ALGORITHM : Algorithm.valueOf(algorithmString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Classification UpdateProcessor Algorithm: '" + algorithmString + "' not supported");
            }
            this.classificationParams.setAlgorithm(classificationAlgorithm);
            this.classificationParams.setMinTf(this.getIntParam(this.params, KNN_MIN_TF_PARAM, 1));
            this.classificationParams.setMinDf(this.getIntParam(this.params, KNN_MIN_DF_PARAM, 1));
            this.classificationParams.setK(this.getIntParam(this.params, KNN_K_PARAM, 10));
        }
    }

    private int getIntParam(SolrParams params, String name, int defaultValue) {
        String paramString = params.get(name);
        int paramInt = paramString != null && !paramString.isEmpty() ? Integer.parseInt(paramString) : defaultValue;
        return paramInt;
    }

    private void checkNotNull(String paramName, Object param) {
        if (param == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Classification UpdateProcessor '" + paramName + "' can not be null");
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        String trainingFilterQueryString = this.params.get(KNN_FILTER_QUERY);
        try {
            if (trainingFilterQueryString != null && !trainingFilterQueryString.isEmpty()) {
                Query trainingFilterQuery = this.parseFilterQuery(trainingFilterQueryString, this.params, req);
                this.classificationParams.setTrainingFilterQuery(trainingFilterQuery);
            }
        }
        catch (RuntimeException | SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Classification UpdateProcessor Training Filter Query: '" + trainingFilterQueryString + "' is not supported", (Throwable)syntaxError);
        }
        IndexSchema schema = req.getSchema();
        DirectoryReader indexReader = req.getSearcher().getIndexReader();
        return new ClassificationUpdateProcessor(this.classificationParams, next, (IndexReader)indexReader, schema);
    }

    private Query parseFilterQuery(String trainingFilterQueryString, SolrParams params, SolrQueryRequest req) throws SyntaxError {
        LuceneQParser parser = new LuceneQParser(trainingFilterQueryString, null, params, req);
        return parser.parse();
    }

    public ClassificationUpdateProcessorParams getClassificationParams() {
        return this.classificationParams;
    }

    public void setClassificationParams(ClassificationUpdateProcessorParams classificationParams) {
        this.classificationParams = classificationParams;
    }

    public static enum Algorithm {
        KNN,
        BAYES;

    }
}

