/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.Date;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.DateMathParser;

public class DateMathFunction {
    public static final String name = "date_math";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length < 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires at least 2 paramaters, " + params.length + " found.");
        }
        StringBuilder mathParam = new StringBuilder();
        for (int i = 1; i < params.length; ++i) {
            if (!(params[i] instanceof StringValue) || !(params[i] instanceof ConstantValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires all math parameters to be a constant strings.");
            }
            mathParam.append(((StringValue)params[i]).getString());
        }
        if (params[0] instanceof DateValue) {
            return new DateMathValueFunction((DateValue)params[0], new ConstantStringValue(mathParam.toString()));
        }
        if (params[0] instanceof DateValueStream) {
            return new DateMathStreamFunction((DateValueStream)params[0], new ConstantStringValue(mathParam.toString()));
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires a date as the first parameter.");
    };

    static class DateMathStreamFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream dateParam;
        private final String mathParam;
        public static final String name = "date_math";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateMathStreamFunction(DateValueStream dateParam, ConstantStringValue mathParam) throws SolrException {
            this.dateParam = dateParam;
            this.mathParam = "NOW" + mathParam.getString();
            this.exprStr = AnalyticsValueStream.createExpressionString("date_math", dateParam, mathParam);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, dateParam);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.streamDates(value -> cons.accept(value.getTime()));
        }

        @Override
        public void streamDates(Consumer<Date> cons) {
            this.dateParam.streamDates(value -> cons.accept(DateMathParser.parseMath((Date)value, (String)this.mathParam)));
        }

        @Override
        public String getName() {
            return "date_math";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateMathValueFunction
    extends DateValue.AbstractDateValue {
        private final DateValue dateParam;
        private final String mathParam;
        DateMathParser parser = new DateMathParser();
        public static final String name = "date_math";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public DateMathValueFunction(DateValue dateParam, ConstantStringValue mathParam) throws SolrException {
            this.dateParam = dateParam;
            this.mathParam = "NOW" + mathParam.getString();
            this.exprStr = AnalyticsValueStream.createExpressionString("date_math", dateParam, mathParam);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, dateParam);
        }

        @Override
        public long getLong() {
            Date date = this.getDate();
            return this.exists ? date.getTime() : 0L;
        }

        @Override
        public Date getDate() {
            Date date = this.dateParam.getDate();
            if (this.dateParam.exists()) {
                this.exists = true;
                return DateMathParser.parseMath((Date)date, (String)this.mathParam);
            }
            this.exists = false;
            return null;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "date_math";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

