/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.DoubleCheckedReservation;
import org.apache.solr.analytics.stream.reservation.FloatCheckedReservation;
import org.apache.solr.analytics.stream.reservation.IntCheckedReservation;
import org.apache.solr.analytics.stream.reservation.LongCheckedReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.stream.reservation.StringCheckedReservation;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public abstract class MaxCollector<T extends ReductionData>
extends ReductionDataCollector<T> {
    public static final String name = "max";
    private final String exprStr;
    private boolean exists;

    protected MaxCollector(AnalyticsValueStream param) {
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.exists = data.exists;
    }

    @Override
    public void setData(ReductionData data) {
        this.exists = data.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class StringMaxCollector
    extends MaxCollector<MaxData> {
        private StringValueStream param;
        String max;
        String tempMax;
        boolean tempExists;

        public StringMaxCollector(StringValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MaxData newData() {
            MaxData data = new MaxData();
            data.exists = false;
            return data;
        }

        public String max() {
            return this.max;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamStrings(val -> {
                if (!this.tempExists || val.compareTo(this.tempMax) > 0) {
                    this.tempMax = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MaxData data) {
            if (this.tempExists && (!data.exists || this.tempMax.compareTo(data.val) > 0)) {
                data.val = this.tempMax;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new StringCheckedReservation(value -> {
                if (!((MaxData)this.ioData).exists || value.compareTo(((MaxData)this.ioData).val) > 0) {
                    ((MaxData)this.ioData).val = value;
                    ((MaxData)this.ioData).exists = true;
                }
            }, () -> ((MaxData)this.ioData).val, () -> ((MaxData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        public static class MaxData
        extends ReductionData {
            String val;
        }
    }

    public static class DoubleMaxCollector
    extends MaxCollector<MaxData> {
        private DoubleValueStream param;
        double max;
        double tempMax;
        boolean tempExists;

        public DoubleMaxCollector(DoubleValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MaxData newData() {
            MaxData data = new MaxData();
            data.exists = false;
            return data;
        }

        public double max() {
            return this.max;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamDoubles(val -> {
                if (!this.tempExists || val > this.tempMax) {
                    this.tempMax = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MaxData data) {
            if (this.tempExists && (!data.exists || this.tempMax > data.val)) {
                data.val = this.tempMax;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new DoubleCheckedReservation(value -> {
                if (!((MaxData)this.ioData).exists || value > ((MaxData)this.ioData).val) {
                    ((MaxData)this.ioData).val = value;
                    ((MaxData)this.ioData).exists = true;
                }
            }, () -> ((MaxData)this.ioData).val, () -> ((MaxData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        public static class MaxData
        extends ReductionData {
            double val;
        }
    }

    public static class FloatMaxCollector
    extends MaxCollector<MaxData> {
        private FloatValueStream param;
        float max;
        float tempMax;
        boolean tempExists;

        public FloatMaxCollector(FloatValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MaxData newData() {
            MaxData data = new MaxData();
            data.exists = false;
            return data;
        }

        public float max() {
            return this.max;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamFloats(val -> {
                if (!this.tempExists || val > this.tempMax) {
                    this.tempMax = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MaxData data) {
            if (this.tempExists && (!data.exists || this.tempMax > data.val)) {
                data.val = this.tempMax;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new FloatCheckedReservation(value -> {
                if (!((MaxData)this.ioData).exists || value > ((MaxData)this.ioData).val) {
                    ((MaxData)this.ioData).val = value;
                    ((MaxData)this.ioData).exists = true;
                }
            }, () -> ((MaxData)this.ioData).val, () -> ((MaxData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        public static class MaxData
        extends ReductionData {
            float val;
        }
    }

    public static class LongMaxCollector
    extends MaxCollector<MaxData> {
        private LongValueStream param;
        long max;
        long tempMax;
        boolean tempExists;

        public LongMaxCollector(LongValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MaxData newData() {
            MaxData data = new MaxData();
            data.exists = false;
            return data;
        }

        public long max() {
            return this.max;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamLongs(val -> {
                if (!this.tempExists || val > this.tempMax) {
                    this.tempMax = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MaxData data) {
            if (this.tempExists && (!data.exists || this.tempMax > data.val)) {
                data.val = this.tempMax;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new LongCheckedReservation(value -> {
                if (!((MaxData)this.ioData).exists || value > ((MaxData)this.ioData).val) {
                    ((MaxData)this.ioData).val = value;
                    ((MaxData)this.ioData).exists = true;
                }
            }, () -> ((MaxData)this.ioData).val, () -> ((MaxData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        public static class MaxData
        extends ReductionData {
            long val;
        }
    }

    public static class IntMaxCollector
    extends MaxCollector<MaxData> {
        private IntValueStream param;
        int max;
        int tempMax;
        boolean tempExists;

        public IntMaxCollector(IntValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MaxData newData() {
            MaxData data = new MaxData();
            data.exists = false;
            return data;
        }

        public int max() {
            return this.max;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamInts(val -> {
                if (!this.tempExists || val > this.tempMax) {
                    this.tempMax = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MaxData data) {
            if (this.tempExists && (!data.exists || this.tempMax > data.val)) {
                data.val = this.tempMax;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new IntCheckedReservation(value -> {
                if (!((MaxData)this.ioData).exists || value > ((MaxData)this.ioData).val) {
                    ((MaxData)this.ioData).val = value;
                    ((MaxData)this.ioData).exists = true;
                }
            }, () -> ((MaxData)this.ioData).val, () -> ((MaxData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.max = ((MaxData)data).val;
        }

        public static class MaxData
        extends ReductionData {
            int val;
        }
    }
}

