/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.disconnect;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectBuilder;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttDisconnectBuilder<B extends MqttDisconnectBuilder<B>> {
    @NotNull
    private Mqtt5DisconnectReasonCode reasonCode = MqttDisconnect.DEFAULT_REASON_CODE;
    private long sessionExpiryInterval = -1L;
    @Nullable
    private MqttUtf8StringImpl serverReference;
    @Nullable
    private MqttUtf8StringImpl reasonString;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    MqttDisconnectBuilder() {
    }

    MqttDisconnectBuilder(@NotNull MqttDisconnect disconnect) {
        this.reasonCode = (Mqtt5DisconnectReasonCode)disconnect.getReasonCode();
        this.sessionExpiryInterval = disconnect.getRawSessionExpiryInterval();
        this.serverReference = disconnect.getRawServerReference();
        this.reasonString = disconnect.getRawReasonString();
        this.userProperties = disconnect.getUserProperties();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B reasonCode(@Nullable Mqtt5DisconnectReasonCode reasonCode) {
        this.reasonCode = Checks.notNull(reasonCode, "Reason Code");
        return this.self();
    }

    @NotNull
    public B sessionExpiryInterval(long sessionExpiryInterval) {
        this.sessionExpiryInterval = Checks.unsignedInt(sessionExpiryInterval, "Session expiry interval");
        return this.self();
    }

    @NotNull
    public B noSessionExpiry() {
        this.sessionExpiryInterval = 0xFFFFFFFFL;
        return this.self();
    }

    @NotNull
    public B serverReference(@Nullable String serverReference) {
        this.serverReference = MqttChecks.stringOrNull(serverReference, "Server reference");
        return this.self();
    }

    @NotNull
    public B serverReference(@Nullable MqttUtf8String serverReference) {
        this.serverReference = MqttChecks.stringOrNull(serverReference, "Server reference");
        return this.self();
    }

    @NotNull
    public B reasonString(@Nullable String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this.self();
    }

    @NotNull
    public B reasonString(@Nullable MqttUtf8String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this.self();
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttDisconnectBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public MqttDisconnect build() {
        return new MqttDisconnect(this.reasonCode, this.sessionExpiryInterval, this.serverReference, this.reasonString, this.userProperties);
    }

    public static class SendVoid
    extends MqttDisconnectBuilder<SendVoid>
    implements Mqtt5DisconnectBuilder.SendVoid {
        @NotNull
        private final Consumer<? super MqttDisconnect> parentConsumer;

        public SendVoid(@NotNull Consumer<? super MqttDisconnect> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        SendVoid self() {
            return this;
        }

        @Override
        public void send() {
            this.parentConsumer.accept(this.build());
        }
    }

    public static class Send<P>
    extends MqttDisconnectBuilder<Send<P>>
    implements Mqtt5DisconnectBuilder.Send<P> {
        @NotNull
        private final Function<? super MqttDisconnect, P> parentConsumer;

        public Send(@NotNull Function<? super MqttDisconnect, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends MqttDisconnectBuilder<Nested<P>>
    implements Mqtt5DisconnectBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttDisconnect, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttDisconnect, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyDisconnect() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttDisconnectBuilder<Default>
    implements Mqtt5DisconnectBuilder {
        public Default() {
        }

        Default(@NotNull MqttDisconnect disconnect) {
            super(disconnect);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

