/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

public final class Tokens {
    public static Fragment fragment(String text, Object tag) {
        return new Fragment(text, tag);
    }

    public static Fragment reserved(String name) {
        return Tokens.fragment(name, (Object)Tag.RESERVED);
    }

    public static Fragment identifier(String name) {
        return Tokens.fragment(name, (Object)Tag.IDENTIFIER);
    }

    public static Fragment decimalLiteral(String s) {
        return Tokens.fragment(s, (Object)Tag.DECIMAL);
    }

    public static Fragment integerLiteral(String s) {
        return Tokens.fragment(s, (Object)Tag.INTEGER);
    }

    public static ScientificNotation scientificNotation(String significand, String exponent) {
        return new ScientificNotation(significand, exponent);
    }

    private Tokens() {
    }

    public static enum Tag {
        RESERVED,
        IDENTIFIER,
        INTEGER,
        DECIMAL;

    }

    public static final class ScientificNotation {
        public final String significand;
        public final String exponent;

        @Deprecated
        public ScientificNotation(String mantissa, String exp) {
            this.significand = mantissa;
            this.exponent = exp;
        }

        public String toString() {
            return this.significand + "E" + this.exponent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScientificNotation) {
                ScientificNotation that = (ScientificNotation)obj;
                return this.significand.equals(that.significand) && this.exponent.equals(that.exponent);
            }
            return false;
        }

        public int hashCode() {
            return this.significand.hashCode() * 31 + this.exponent.hashCode();
        }
    }

    public static final class Fragment {
        private final String text;
        private final Object tag;

        @Deprecated
        public Fragment(String text, Object tag) {
            this.text = text;
            this.tag = tag;
        }

        public String text() {
            return this.text;
        }

        public Object tag() {
            return this.tag;
        }

        boolean equalFragment(Fragment that) {
            return this.tag.equals(that.tag) && this.text.equals(that.text);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Fragment) {
                return this.equalFragment((Fragment)obj);
            }
            return false;
        }

        public int hashCode() {
            return this.tag.hashCode() * 31 + this.text.hashCode();
        }

        public String toString() {
            return this.text;
        }
    }
}

