/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.CachedRowSet;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericStatementDecorator;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLiteDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final Logger logger = Logger.getLogger(SQLiteDatabaseMetaDataDecorator.class);

    public SQLiteDatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        super(delegate, connectionDecorator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("select sqlite_version() where 1 = 0");
            CachedRowSet crs = new CachedRowSet();
            crs.populate(rs);
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set. Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement. Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("select sqlite_version() where 1 = 0");
            CachedRowSet crs = new CachedRowSet();
            crs.populate(rs);
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set. Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement. Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("select sqlite_version() where 1 = 0");
            CachedRowSet crs = new CachedRowSet();
            crs.populate(rs);
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close result set. Squishing this exception: ", (Throwable)ex);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    logger.error((Object)"Failed to close statement. Squishing this exception: ", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected ResultSetDecorator wrap(ResultSet rs) throws SQLException {
        return new GenericResultSetDecorator(this.wrap(rs.getStatement()), rs);
    }

    @Override
    protected StatementDecorator wrap(Statement statement) {
        return new GenericStatementDecorator(this.connectionDecorator, statement);
    }
}

