/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.flattener;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.flattener.Flattener;
import org.pentaho.di.trans.steps.flattener.FlattenerData;
import org.pentaho.di.trans.steps.flattener.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlattenerMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fieldName;
    private String[] targetField;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String[] targetField) {
        this.targetField = targetField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.targetField = new String[nrfields];
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.fieldName != null && this.fieldName.length() > 0) {
            int idx = row.indexOfValue(this.fieldName);
            if (idx < 0) {
                throw new KettleStepException(Messages.getString("FlattenerMeta.Exception.UnableToLocateFieldInInputFields", this.fieldName));
            }
            ValueMetaInterface v = row.getValueMeta(idx);
            row.removeValueMeta(idx);
            for (int i = 0; i < this.targetField.length; ++i) {
                ValueMetaInterface value = v.clone();
                value.setName(this.targetField[i]);
                value.setOrigin(name);
                row.addValueMeta(value);
            }
        } else {
            throw new KettleStepException(Messages.getString("FlattenerMeta.Exception.FlattenFieldRequired"));
        }
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"field_name");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.targetField[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("FlattenerMeta.Exception.UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"field_name", (String)this.fieldName));
        retval.append("      <fields>" + Const.CR);
        for (int i = 0; i < this.targetField.length; ++i) {
            retval.append("        <field>" + Const.CR);
            retval.append("          " + XMLHandler.addTagValue((String)"name", (String)this.targetField[i]));
            retval.append("          </field>" + Const.CR);
        }
        retval.append("        </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.fieldName = rep.getStepAttributeString(id_step, "field_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "target_field");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.targetField[i] = rep.getStepAttributeString(id_step, i, "target_field");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FlattenerMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "field_name", this.fieldName);
            for (int i = 0; i < this.targetField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_field", this.targetField[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FlattenerMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, Messages.getString("FlattenerMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, Messages.getString("FlattenerMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Flattener(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FlattenerData();
    }
}

