/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import java.lang.reflect.Array;

public class ArraysCompat {
    public static char[] copyOf(char[] original, int newLength) {
        return ArraysCompat.copyOfRange(original, 0, newLength);
    }

    public static int[] copyOf(int[] original, int newLength) {
        return ArraysCompat.copyOfRange(original, 0, newLength);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return ArraysCompat.copyOfRange(original, 0, newLength);
    }

    public static char[] copyOfRange(char[] original, int start, int end) {
        int originalLength = original.length;
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        char[] result = new char[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static int[] copyOfRange(int[] original, int start, int end) {
        int originalLength = original.length;
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        int[] result = new int[resultLength];
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static <T> T[] copyOfRange(T[] original, int start, int end) {
        int originalLength = original.length;
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        Object[] result = (Object[])Array.newInstance(original.getClass().getComponentType(), resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }
}

