// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceDataLossPreventionJobTrigger() *schema.Resource {
	return &schema.Resource{
		Create: resourceDataLossPreventionJobTriggerCreate,
		Read:   resourceDataLossPreventionJobTriggerRead,
		Update: resourceDataLossPreventionJobTriggerUpdate,
		Delete: resourceDataLossPreventionJobTriggerDelete,

		Importer: &schema.ResourceImporter{
			State: resourceDataLossPreventionJobTriggerImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"parent": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `The parent of the trigger, either in the format 'projects/{{project}}'
or 'projects/{{project}}/locations/{{location}}'`,
			},
			"triggers": {
				Type:        schema.TypeList,
				Required:    true,
				Description: `What event needs to occur for a new job to be started.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"schedule": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Schedule for triggered jobs`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"recurrence_period_duration": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `With this option a job is started a regular periodic basis. For example: every day (86400 seconds).

A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.

This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.

A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".`,
									},
								},
							},
						},
					},
				},
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `A description of the job trigger.`,
			},
			"display_name": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `User set display name of the job trigger.`,
			},
			"inspect_job": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Controls what and how to inspect for findings.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"actions": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `A task to execute on the completion of a job.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"save_findings": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Schedule for triggered jobs`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"output_config": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Information on where to store output`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"table": {
																Type:        schema.TypeList,
																Required:    true,
																Description: `Information on the location of the target BigQuery Table.`,
																MaxItems:    1,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"dataset_id": {
																			Type:        schema.TypeString,
																			Required:    true,
																			Description: `Dataset ID of the table.`,
																		},
																		"project_id": {
																			Type:        schema.TypeString,
																			Required:    true,
																			Description: `The Google Cloud Platform project ID of the project containing the table.`,
																		},
																		"table_id": {
																			Type:     schema.TypeString,
																			Optional: true,
																			Description: `Name of the table. If is not set a new one will be generated for you with the following format:
'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.`,
																		},
																	},
																},
															},
															"output_schema": {
																Type:         schema.TypeString,
																Optional:     true,
																ValidateFunc: validateEnum([]string{"BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS", ""}),
																Description: `Schema used for writing the findings for Inspect jobs. This field is only used for
Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
object. If appending to an existing table, any columns from the predefined schema
that are missing will be added. No columns in the existing table will be deleted.

If unspecified, then all available columns will be used for a new table or an (existing)
table with no schema, and no changes will be made to an existing table that has a schema.
Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]`,
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						"inspect_template_name": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The name of the template to run when this job is triggered.`,
						},
						"storage_config": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Information on where to inspect`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"big_query_options": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Options defining BigQuery table and row identifiers.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"table_reference": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Set of files to scan.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"dataset_id": {
																Type:        schema.TypeString,
																Required:    true,
																Description: `The dataset ID of the table.`,
															},
															"project_id": {
																Type:        schema.TypeString,
																Required:    true,
																Description: `The Google Cloud Platform project ID of the project containing the table.`,
															},
															"table_id": {
																Type:        schema.TypeString,
																Required:    true,
																Description: `The name of the table.`,
															},
														},
													},
												},
											},
										},
									},
									"cloud_storage_options": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Options defining a file or a set of files within a Google Cloud Storage bucket.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"file_set": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Set of files to scan.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"regex_file_set": {
																Type:        schema.TypeList,
																Optional:    true,
																Description: `The regex-filtered set of files to scan.`,
																MaxItems:    1,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"bucket_name": {
																			Type:        schema.TypeString,
																			Required:    true,
																			Description: `The name of a Cloud Storage bucket.`,
																		},
																		"exclude_regex": {
																			Type:     schema.TypeList,
																			Optional: true,
																			Description: `A list of regular expressions matching file paths to exclude. All files in the bucket that match at
least one of these regular expressions will be excluded from the scan.`,
																			Elem: &schema.Schema{
																				Type: schema.TypeString,
																			},
																		},
																		"include_regex": {
																			Type:     schema.TypeList,
																			Optional: true,
																			Description: `A list of regular expressions matching file paths to include. All files in the bucket
that match at least one of these regular expressions will be included in the set of files,
except for those that also match an item in excludeRegex. Leaving this field empty will
match all files by default (this is equivalent to including .* in the list)`,
																			Elem: &schema.Schema{
																				Type: schema.TypeString,
																			},
																		},
																	},
																},
																ExactlyOneOf: []string{"inspect_job.0.storage_config.0.cloud_storage_options.0.file_set.0.url", "inspect_job.0.storage_config.0.cloud_storage_options.0.file_set.0.regex_file_set"},
															},
															"url": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard
in the path is allowed.

If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.`,
																ExactlyOneOf: []string{"inspect_job.0.storage_config.0.cloud_storage_options.0.file_set.0.url", "inspect_job.0.storage_config.0.cloud_storage_options.0.file_set.0.regex_file_set"},
															},
														},
													},
												},
												"bytes_limit_per_file": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Max number of bytes to scan from a file. If a scanned file's size is bigger than this value
then the rest of the bytes are omitted.`,
												},
												"bytes_limit_per_file_percent": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Max percentage of bytes to scan from a file. The rest are omitted. The number of bytes scanned is rounded down.
Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.`,
												},
												"file_types": {
													Type:     schema.TypeList,
													Optional: true,
													Description: `List of file type groups to include in the scan. If empty, all files are scanned and available data
format processors are applied. In addition, the binary content of the selected files is always scanned as well.
Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]`,
													Elem: &schema.Schema{
														Type:         schema.TypeString,
														ValidateFunc: validateEnum([]string{"BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"}),
													},
												},
												"files_limit_percent": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Limits the number of files to scan to this percentage of the input FileSet. Number of files scanned is rounded down.
Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.`,
												},
												"sample_method": {
													Type:         schema.TypeString,
													Optional:     true,
													ValidateFunc: validateEnum([]string{"TOP", "RANDOM_START", ""}),
													Description: `How to sample bytes if not all bytes are scanned. Meaningful only when used in conjunction with bytesLimitPerFile.
If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]`,
												},
											},
										},
									},
									"datastore_options": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Options defining a data set within Google Cloud Datastore.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"kind": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `A representation of a Datastore kind.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"name": {
																Type:        schema.TypeString,
																Required:    true,
																Description: `The name of the Datastore kind.`,
															},
														},
													},
												},
												"partition_id": {
													Type:     schema.TypeList,
													Required: true,
													Description: `Datastore partition ID. A partition ID identifies a grouping of entities. The grouping
is always by project and namespace, however the namespace ID may be empty.`,
													MaxItems: 1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"project_id": {
																Type:        schema.TypeString,
																Required:    true,
																Description: `The ID of the project to which the entities belong.`,
															},
															"namespace_id": {
																Type:        schema.TypeString,
																Optional:    true,
																Description: `If not empty, the ID of the namespace to which the entities belong.`,
															},
														},
													},
												},
											},
										},
									},
									"timespan_config": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Information on where to inspect`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"timestamp_field": {
													Type:        schema.TypeList,
													Required:    true,
													Description: `Information on where to inspect`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"name": {
																Type:     schema.TypeString,
																Required: true,
																Description: `Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.

For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.

For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
timestamp property does not exist or its value is empty or invalid.`,
															},
														},
													},
												},
												"enable_auto_population_of_timespan_config": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid
scanning files that have not been modified since the last time the JobTrigger executed. This will
be based on the time of the execution of the last run of the JobTrigger.`,
												},
												"end_time": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.`,
													AtLeastOneOf: []string{"inspect_job.0.storage_config.0.timespan_config.0.start_time", "inspect_job.0.storage_config.0.timespan_config.0.end_time"},
												},
												"start_time": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Exclude files or rows older than this value.`,
													AtLeastOneOf: []string{"inspect_job.0.storage_config.0.timespan_config.0.start_time", "inspect_job.0.storage_config.0.timespan_config.0.end_time"},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
			"status": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validateEnum([]string{"PAUSED", "HEALTHY", "CANCELLED", ""}),
				Description:  `Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]`,
				Default:      "HEALTHY",
			},
			"last_run_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The timestamp of the last time this trigger executed.`,
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The resource name of the job trigger. Set by the server.`,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceDataLossPreventionJobTriggerCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	descriptionProp, err := expandDataLossPreventionJobTriggerDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	displayNameProp, err := expandDataLossPreventionJobTriggerDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(displayNameProp)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	statusProp, err := expandDataLossPreventionJobTriggerStatus(d.Get("status"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("status"); !isEmptyValue(reflect.ValueOf(statusProp)) && (ok || !reflect.DeepEqual(v, statusProp)) {
		obj["status"] = statusProp
	}
	triggersProp, err := expandDataLossPreventionJobTriggerTriggers(d.Get("triggers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("triggers"); !isEmptyValue(reflect.ValueOf(triggersProp)) && (ok || !reflect.DeepEqual(v, triggersProp)) {
		obj["triggers"] = triggersProp
	}
	inspectJobProp, err := expandDataLossPreventionJobTriggerInspectJob(d.Get("inspect_job"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("inspect_job"); !isEmptyValue(reflect.ValueOf(inspectJobProp)) && (ok || !reflect.DeepEqual(v, inspectJobProp)) {
		obj["inspectJob"] = inspectJobProp
	}

	obj, err = resourceDataLossPreventionJobTriggerEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{DataLossPreventionBasePath}}{{parent}}/jobTriggers")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new JobTrigger: %#v", obj)
	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating JobTrigger: %s", err)
	}
	if err := d.Set("name", flattenDataLossPreventionJobTriggerName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{parent}}/jobTriggers/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating JobTrigger %q: %#v", d.Id(), res)

	return resourceDataLossPreventionJobTriggerRead(d, meta)
}

func resourceDataLossPreventionJobTriggerRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{DataLossPreventionBasePath}}{{parent}}/jobTriggers/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("DataLossPreventionJobTrigger %q", d.Id()))
	}

	if err := d.Set("name", flattenDataLossPreventionJobTriggerName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("description", flattenDataLossPreventionJobTriggerDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("display_name", flattenDataLossPreventionJobTriggerDisplayName(res["displayName"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("last_run_time", flattenDataLossPreventionJobTriggerLastRunTime(res["lastRunTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("status", flattenDataLossPreventionJobTriggerStatus(res["status"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("triggers", flattenDataLossPreventionJobTriggerTriggers(res["triggers"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}
	if err := d.Set("inspect_job", flattenDataLossPreventionJobTriggerInspectJob(res["inspectJob"], d, config)); err != nil {
		return fmt.Errorf("Error reading JobTrigger: %s", err)
	}

	return nil
}

func resourceDataLossPreventionJobTriggerUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	obj := make(map[string]interface{})
	descriptionProp, err := expandDataLossPreventionJobTriggerDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	displayNameProp, err := expandDataLossPreventionJobTriggerDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	statusProp, err := expandDataLossPreventionJobTriggerStatus(d.Get("status"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("status"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, statusProp)) {
		obj["status"] = statusProp
	}
	triggersProp, err := expandDataLossPreventionJobTriggerTriggers(d.Get("triggers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("triggers"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, triggersProp)) {
		obj["triggers"] = triggersProp
	}
	inspectJobProp, err := expandDataLossPreventionJobTriggerInspectJob(d.Get("inspect_job"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("inspect_job"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, inspectJobProp)) {
		obj["inspectJob"] = inspectJobProp
	}

	obj, err = resourceDataLossPreventionJobTriggerEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{DataLossPreventionBasePath}}{{parent}}/jobTriggers/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating JobTrigger %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("description") {
		updateMask = append(updateMask, "description")
	}

	if d.HasChange("display_name") {
		updateMask = append(updateMask, "displayName")
	}

	if d.HasChange("status") {
		updateMask = append(updateMask, "status")
	}

	if d.HasChange("triggers") {
		updateMask = append(updateMask, "triggers")
	}

	if d.HasChange("inspect_job") {
		updateMask = append(updateMask, "inspectJob")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating JobTrigger %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating JobTrigger %q: %#v", d.Id(), res)
	}

	return resourceDataLossPreventionJobTriggerRead(d, meta)
}

func resourceDataLossPreventionJobTriggerDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	url, err := replaceVars(d, config, "{{DataLossPreventionBasePath}}{{parent}}/jobTriggers/{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting JobTrigger %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "JobTrigger")
	}

	log.Printf("[DEBUG] Finished deleting JobTrigger %q: %#v", d.Id(), res)
	return nil
}

func resourceDataLossPreventionJobTriggerImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)

	// Custom import to handle parent possibilities
	if err := parseImportId([]string{"(?P<name>.+)"}, d, config); err != nil {
		return nil, err
	}
	parts := strings.Split(d.Get("name").(string), "/")
	if len(parts) == 6 {
		if err := d.Set("name", parts[5]); err != nil {
			return nil, fmt.Errorf("Error setting name: %s", err)
		}
	} else if len(parts) == 4 {
		if err := d.Set("name", parts[3]); err != nil {
			return nil, fmt.Errorf("Error setting name: %s", err)
		}
	} else {
		return nil, fmt.Errorf("Unexpected import id: %s, expected form {{parent}}/jobTrigger/{{name}}", d.Get("name").(string))
	}
	// Remove "/jobTrigger/{{name}}" from the id
	parts = parts[:len(parts)-2]
	if err := d.Set("parent", strings.Join(parts, "/")); err != nil {
		return nil, fmt.Errorf("Error setting parent: %s", err)
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "{{parent}}/jobTriggers/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenDataLossPreventionJobTriggerName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return NameFromSelfLinkStateFunc(v)
}

func flattenDataLossPreventionJobTriggerDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerLastRunTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerStatus(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerTriggers(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"schedule": flattenDataLossPreventionJobTriggerTriggersSchedule(original["schedule"], d, config),
		})
	}
	return transformed
}
func flattenDataLossPreventionJobTriggerTriggersSchedule(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["recurrence_period_duration"] =
		flattenDataLossPreventionJobTriggerTriggersScheduleRecurrencePeriodDuration(original["recurrencePeriodDuration"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerTriggersScheduleRecurrencePeriodDuration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJob(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["inspect_template_name"] =
		flattenDataLossPreventionJobTriggerInspectJobInspectTemplateName(original["inspectTemplateName"], d, config)
	transformed["storage_config"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfig(original["storageConfig"], d, config)
	transformed["actions"] =
		flattenDataLossPreventionJobTriggerInspectJobActions(original["actions"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobInspectTemplateName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["timespan_config"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig(original["timespanConfig"], d, config)
	transformed["datastore_options"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions(original["datastoreOptions"], d, config)
	transformed["cloud_storage_options"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions(original["cloudStorageOptions"], d, config)
	transformed["big_query_options"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions(original["bigQueryOptions"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["start_time"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigStartTime(original["startTime"], d, config)
	transformed["end_time"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEndTime(original["endTime"], d, config)
	transformed["enable_auto_population_of_timespan_config"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEnableAutoPopulationOfTimespanConfig(original["enableAutoPopulationOfTimespanConfig"], d, config)
	transformed["timestamp_field"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField(original["timestampField"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigStartTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEndTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEnableAutoPopulationOfTimespanConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["name"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldName(original["name"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["partition_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId(original["partitionId"], d, config)
	transformed["kind"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind(original["kind"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdProjectId(original["projectId"], d, config)
	transformed["namespace_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdNamespaceId(original["namespaceId"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdNamespaceId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["name"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindName(original["name"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["file_set"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet(original["fileSet"], d, config)
	transformed["bytes_limit_per_file"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFile(original["bytesLimitPerFile"], d, config)
	transformed["bytes_limit_per_file_percent"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFilePercent(original["bytesLimitPerFilePercent"], d, config)
	transformed["files_limit_percent"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFilesLimitPercent(original["filesLimitPercent"], d, config)
	transformed["file_types"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileTypes(original["fileTypes"], d, config)
	transformed["sample_method"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsSampleMethod(original["sampleMethod"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["url"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetUrl(original["url"], d, config)
	transformed["regex_file_set"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet(original["regexFileSet"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket_name"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetBucketName(original["bucketName"], d, config)
	transformed["include_regex"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetIncludeRegex(original["includeRegex"], d, config)
	transformed["exclude_regex"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetExcludeRegex(original["excludeRegex"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetBucketName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetIncludeRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetExcludeRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFilePercent(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFilesLimitPercent(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileTypes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsSampleMethod(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["table_reference"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference(original["tableReference"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceProjectId(original["projectId"], d, config)
	transformed["dataset_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceDatasetId(original["datasetId"], d, config)
	transformed["table_id"] =
		flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceTableId(original["tableId"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceDatasetId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceTableId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobActions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"save_findings": flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindings(original["saveFindings"], d, config),
		})
	}
	return transformed
}
func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindings(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["output_config"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig(original["outputConfig"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["table"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable(original["table"], d, config)
	transformed["output_schema"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputSchema(original["outputSchema"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableProjectId(original["projectId"], d, config)
	transformed["dataset_id"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableDatasetId(original["datasetId"], d, config)
	transformed["table_id"] =
		flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableTableId(original["tableId"], d, config)
	return []interface{}{transformed}
}
func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableDatasetId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableTableId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputSchema(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandDataLossPreventionJobTriggerDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerStatus(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerTriggers(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedSchedule, err := expandDataLossPreventionJobTriggerTriggersSchedule(original["schedule"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSchedule); val.IsValid() && !isEmptyValue(val) {
			transformed["schedule"] = transformedSchedule
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDataLossPreventionJobTriggerTriggersSchedule(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedRecurrencePeriodDuration, err := expandDataLossPreventionJobTriggerTriggersScheduleRecurrencePeriodDuration(original["recurrence_period_duration"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRecurrencePeriodDuration); val.IsValid() && !isEmptyValue(val) {
		transformed["recurrencePeriodDuration"] = transformedRecurrencePeriodDuration
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerTriggersScheduleRecurrencePeriodDuration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJob(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInspectTemplateName, err := expandDataLossPreventionJobTriggerInspectJobInspectTemplateName(original["inspect_template_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInspectTemplateName); val.IsValid() && !isEmptyValue(val) {
		transformed["inspectTemplateName"] = transformedInspectTemplateName
	}

	transformedStorageConfig, err := expandDataLossPreventionJobTriggerInspectJobStorageConfig(original["storage_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStorageConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["storageConfig"] = transformedStorageConfig
	}

	transformedActions, err := expandDataLossPreventionJobTriggerInspectJobActions(original["actions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedActions); val.IsValid() && !isEmptyValue(val) {
		transformed["actions"] = transformedActions
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobInspectTemplateName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTimespanConfig, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig(original["timespan_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimespanConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["timespanConfig"] = transformedTimespanConfig
	}

	transformedDatastoreOptions, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions(original["datastore_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatastoreOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["datastoreOptions"] = transformedDatastoreOptions
	}

	transformedCloudStorageOptions, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions(original["cloud_storage_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCloudStorageOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["cloudStorageOptions"] = transformedCloudStorageOptions
	}

	transformedBigQueryOptions, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions(original["big_query_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBigQueryOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["bigQueryOptions"] = transformedBigQueryOptions
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedStartTime, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigStartTime(original["start_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStartTime); val.IsValid() && !isEmptyValue(val) {
		transformed["startTime"] = transformedStartTime
	}

	transformedEndTime, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEndTime(original["end_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEndTime); val.IsValid() && !isEmptyValue(val) {
		transformed["endTime"] = transformedEndTime
	}

	transformedEnableAutoPopulationOfTimespanConfig, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEnableAutoPopulationOfTimespanConfig(original["enable_auto_population_of_timespan_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnableAutoPopulationOfTimespanConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["enableAutoPopulationOfTimespanConfig"] = transformedEnableAutoPopulationOfTimespanConfig
	}

	transformedTimestampField, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField(original["timestamp_field"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimestampField); val.IsValid() && !isEmptyValue(val) {
		transformed["timestampField"] = transformedTimestampField
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigStartTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEndTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigEnableAutoPopulationOfTimespanConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedName, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPartitionId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId(original["partition_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPartitionId); val.IsValid() && !isEmptyValue(val) {
		transformed["partitionId"] = transformedPartitionId
	}

	transformedKind, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind(original["kind"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKind); val.IsValid() && !isEmptyValue(val) {
		transformed["kind"] = transformedKind
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedNamespaceId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdNamespaceId(original["namespace_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNamespaceId); val.IsValid() && !isEmptyValue(val) {
		transformed["namespaceId"] = transformedNamespaceId
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdNamespaceId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedName, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedFileSet, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet(original["file_set"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFileSet); val.IsValid() && !isEmptyValue(val) {
		transformed["fileSet"] = transformedFileSet
	}

	transformedBytesLimitPerFile, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFile(original["bytes_limit_per_file"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBytesLimitPerFile); val.IsValid() && !isEmptyValue(val) {
		transformed["bytesLimitPerFile"] = transformedBytesLimitPerFile
	}

	transformedBytesLimitPerFilePercent, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFilePercent(original["bytes_limit_per_file_percent"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBytesLimitPerFilePercent); val.IsValid() && !isEmptyValue(val) {
		transformed["bytesLimitPerFilePercent"] = transformedBytesLimitPerFilePercent
	}

	transformedFilesLimitPercent, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFilesLimitPercent(original["files_limit_percent"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFilesLimitPercent); val.IsValid() && !isEmptyValue(val) {
		transformed["filesLimitPercent"] = transformedFilesLimitPercent
	}

	transformedFileTypes, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileTypes(original["file_types"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFileTypes); val.IsValid() && !isEmptyValue(val) {
		transformed["fileTypes"] = transformedFileTypes
	}

	transformedSampleMethod, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsSampleMethod(original["sample_method"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSampleMethod); val.IsValid() && !isEmptyValue(val) {
		transformed["sampleMethod"] = transformedSampleMethod
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedUrl, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetUrl(original["url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["url"] = transformedUrl
	}

	transformedRegexFileSet, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet(original["regex_file_set"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRegexFileSet); val.IsValid() && !isEmptyValue(val) {
		transformed["regexFileSet"] = transformedRegexFileSet
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucketName, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetBucketName(original["bucket_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucketName); val.IsValid() && !isEmptyValue(val) {
		transformed["bucketName"] = transformedBucketName
	}

	transformedIncludeRegex, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetIncludeRegex(original["include_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIncludeRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["includeRegex"] = transformedIncludeRegex
	}

	transformedExcludeRegex, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetExcludeRegex(original["exclude_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExcludeRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["excludeRegex"] = transformedExcludeRegex
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetBucketName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetIncludeRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetExcludeRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsBytesLimitPerFilePercent(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFilesLimitPercent(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileTypes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsSampleMethod(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTableReference, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference(original["table_reference"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTableReference); val.IsValid() && !isEmptyValue(val) {
		transformed["tableReference"] = transformedTableReference
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceDatasetId(original["dataset_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId, err := expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceTableId(original["table_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceDatasetId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceTableId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobActions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedSaveFindings, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindings(original["save_findings"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSaveFindings); val.IsValid() && !isEmptyValue(val) {
			transformed["saveFindings"] = transformedSaveFindings
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindings(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedOutputConfig, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig(original["output_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOutputConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["outputConfig"] = transformedOutputConfig
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTable, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable(original["table"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTable); val.IsValid() && !isEmptyValue(val) {
		transformed["table"] = transformedTable
	}

	transformedOutputSchema, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputSchema(original["output_schema"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOutputSchema); val.IsValid() && !isEmptyValue(val) {
		transformed["outputSchema"] = transformedOutputSchema
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedDatasetId, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableDatasetId(original["dataset_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatasetId); val.IsValid() && !isEmptyValue(val) {
		transformed["datasetId"] = transformedDatasetId
	}

	transformedTableId, err := expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableTableId(original["table_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTableId); val.IsValid() && !isEmptyValue(val) {
		transformed["tableId"] = transformedTableId
	}

	return transformed, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableDatasetId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableTableId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputSchema(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceDataLossPreventionJobTriggerEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	newObj := make(map[string]interface{})
	newObj["jobTrigger"] = obj
	return newObj, nil
}
