/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.postgresql.conf;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.properties.BooleanGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;

public class PostgreSQLPasswordPolicy
implements PasswordPolicy {
    private static final IntegerGuacamoleProperty MIN_LENGTH = new IntegerGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-min-length";
        }
    };
    private static final IntegerGuacamoleProperty MIN_AGE = new IntegerGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-min-age";
        }
    };
    private static final IntegerGuacamoleProperty MAX_AGE = new IntegerGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-max-age";
        }
    };
    private static final IntegerGuacamoleProperty HISTORY_SIZE = new IntegerGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-history-size";
        }
    };
    private static final BooleanGuacamoleProperty REQUIRE_MULTIPLE_CASE = new BooleanGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-require-multiple-case";
        }
    };
    private static final BooleanGuacamoleProperty REQUIRE_DIGIT = new BooleanGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-require-digit";
        }
    };
    private static final BooleanGuacamoleProperty REQUIRE_SYMBOL = new BooleanGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-require-symbol";
        }
    };
    private static final BooleanGuacamoleProperty PROHIBIT_USERNAME = new BooleanGuacamoleProperty(){

        public String getName() {
            return "postgresql-user-password-prohibit-username";
        }
    };
    private final JDBCEnvironment environment;

    public PostgreSQLPasswordPolicy(JDBCEnvironment environment) {
        this.environment = environment;
    }

    public int getMinimumLength() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)MIN_LENGTH, (Object)0);
    }

    public int getMinimumAge() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)MIN_AGE, (Object)0);
    }

    public int getMaximumAge() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)MAX_AGE, (Object)0);
    }

    public int getHistorySize() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)HISTORY_SIZE, (Object)0);
    }

    public boolean isMultipleCaseRequired() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)REQUIRE_MULTIPLE_CASE, (Object)false);
    }

    public boolean isNumericRequired() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)REQUIRE_DIGIT, (Object)false);
    }

    public boolean isNonAlphanumericRequired() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)REQUIRE_SYMBOL, (Object)false);
    }

    public boolean isUsernameProhibited() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)PROHIBIT_USERNAME, (Object)false);
    }
}

