/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;
import sun.util.locale.provider.RuleBasedBreakIterator;

class BreakDictionary {
    private static int supportedVersion = 1;
    private CompactByteArray columnMap = null;
    private SupplementaryCharacterData supplementaryCharColumnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    BreakDictionary(String string) throws IOException, MissingResourceException {
        this.readDictionaryFile(string);
    }

    private void readDictionaryFile(final String string) throws IOException, MissingResourceException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedInputStream>(){

                @Override
                public BufferedInputStream run() throws Exception {
                    return new BufferedInputStream(this.getClass().getResourceAsStream("/sun/text/resources/" + string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new InternalError(privilegedActionException.toString(), privilegedActionException);
        }
        byte[] byArray = new byte[8];
        if (bufferedInputStream.read(byArray) != 8) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        int n = RuleBasedBreakIterator.getInt(byArray, 0);
        if (n != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + n + ") is unsupported", string, "");
        }
        int n2 = RuleBasedBreakIterator.getInt(byArray, 4);
        if (bufferedInputStream.read(byArray = new byte[n2]) != n2) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        bufferedInputStream.close();
        int n3 = 0;
        int n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        short[] sArray = new short[n4];
        int n5 = 0;
        while (n5 < n4) {
            sArray[n5] = RuleBasedBreakIterator.getShort(byArray, n3);
            ++n5;
            n3 += 2;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        byte[] byArray2 = new byte[n4];
        int n6 = 0;
        while (n6 < n4) {
            byArray2[n6] = byArray[n3];
            ++n6;
            ++n3;
        }
        this.columnMap = new CompactByteArray(sArray, byArray2);
        this.numCols = RuleBasedBreakIterator.getInt(byArray, n3);
        this.numColGroups = RuleBasedBreakIterator.getInt(byArray, n3 += 4);
        n4 = RuleBasedBreakIterator.getInt(byArray, n3 += 4);
        n3 += 4;
        this.rowIndex = new short[n4];
        n6 = 0;
        while (n6 < n4) {
            this.rowIndex[n6] = RuleBasedBreakIterator.getShort(byArray, n3);
            ++n6;
            n3 += 2;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        this.rowIndexFlagsIndex = new short[n4];
        n6 = 0;
        while (n6 < n4) {
            this.rowIndexFlagsIndex[n6] = RuleBasedBreakIterator.getShort(byArray, n3);
            ++n6;
            n3 += 2;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        this.rowIndexFlags = new int[n4];
        n6 = 0;
        while (n6 < n4) {
            this.rowIndexFlags[n6] = RuleBasedBreakIterator.getInt(byArray, n3);
            ++n6;
            n3 += 4;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        this.rowIndexShifts = new byte[n4];
        n6 = 0;
        while (n6 < n4) {
            this.rowIndexShifts[n6] = byArray[n3];
            ++n6;
            ++n3;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        this.table = new short[n4];
        n6 = 0;
        while (n6 < n4) {
            this.table[n6] = RuleBasedBreakIterator.getShort(byArray, n3);
            ++n6;
            n3 += 2;
        }
        n4 = RuleBasedBreakIterator.getInt(byArray, n3);
        n3 += 4;
        int[] nArray = new int[n4];
        int n7 = 0;
        while (n7 < n4) {
            nArray[n7] = RuleBasedBreakIterator.getInt(byArray, n3);
            ++n7;
            n3 += 4;
        }
        this.supplementaryCharColumnMap = new SupplementaryCharacterData(nArray);
    }

    public final short getNextStateFromCharacter(int n, int n2) {
        int n3 = n2 < 65536 ? (int)this.columnMap.elementAt((char)n2) : this.supplementaryCharColumnMap.getValue(n2);
        return this.getNextState(n, n3);
    }

    public final short getNextState(int n, int n2) {
        if (this.cellIsPopulated(n, n2)) {
            return this.internalAt(this.rowIndex[n], n2 + this.rowIndexShifts[n]);
        }
        return 0;
    }

    private boolean cellIsPopulated(int n, int n2) {
        if (this.rowIndexFlagsIndex[n] < 0) {
            return n2 == -this.rowIndexFlagsIndex[n];
        }
        int n3 = this.rowIndexFlags[this.rowIndexFlagsIndex[n] + (n2 >> 5)];
        return (n3 & 1 << (n2 & 0x1F)) != 0;
    }

    private short internalAt(int n, int n2) {
        return this.table[n * this.numCols + n2];
    }
}

