"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelRouter = void 0;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

var _server = require("../../../../src/core/server");

var _services = require("../services");

var _constants = require("./constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const modelSortQuerySchema = _configSchema.schema.oneOf([_configSchema.schema.literal('name-asc'), _configSchema.schema.literal('name-desc'), _configSchema.schema.literal('model_state-asc'), _configSchema.schema.literal('model_state-desc'), _configSchema.schema.literal('id-asc'), _configSchema.schema.literal('id-desc')]);

const modelStateSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_common.MODEL_STATE.loadFailed), _configSchema.schema.literal(_common.MODEL_STATE.loaded), _configSchema.schema.literal(_common.MODEL_STATE.loading), _configSchema.schema.literal(_common.MODEL_STATE.partiallyLoaded), _configSchema.schema.literal(_common.MODEL_STATE.trained), _configSchema.schema.literal(_common.MODEL_STATE.uploaded), _configSchema.schema.literal(_common.MODEL_STATE.unloaded), _configSchema.schema.literal(_common.MODEL_STATE.uploading)]);

const modelRouter = router => {
  router.get({
    path: _constants.MODEL_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number({
          min: 0
        }),
        size: _configSchema.schema.number({
          max: 50
        }),
        sort: _configSchema.schema.maybe(_configSchema.schema.oneOf([modelSortQuerySchema, _configSchema.schema.arrayOf(modelSortQuerySchema)])),
        states: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(modelStateSchema), modelStateSchema])),
        nameOrId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request) => {
    const {
      from,
      size,
      sort,
      states,
      nameOrId
    } = request.query;

    try {
      const payload = await _services.ModelService.search({
        client: context.core.opensearch.client,
        from,
        size,
        sort: typeof sort === 'string' ? [sort] : sort,
        states: typeof states === 'string' ? [states] : states,
        nameOrId
      });
      return _server.opensearchDashboardsResponseFactory.ok({
        body: payload
      });
    } catch (err) {
      return _server.opensearchDashboardsResponseFactory.badRequest({
        body: err.message
      });
    }
  });
};

exports.modelRouter = modelRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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