"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFindingsMethods = addFindingsMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addFindingsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.GET_FINDINGS}?detector_id=<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZEZpbmRpbmdzTWV0aG9kcy50cyJdLCJuYW1lcyI6WyJhZGRGaW5kaW5nc01ldGhvZHMiLCJzZWN1cml0eUFuYWx5dGljcyIsImNyZWF0ZUFjdGlvbiIsIk1FVEhPRF9OQU1FUyIsIkdFVF9GSU5ESU5HUyIsInVybCIsImZtdCIsIkFQSSIsInJlcSIsImRldGVjdG9ySWQiLCJ0eXBlIiwicmVxdWlyZWQiLCJuZWVkQm9keSIsIm1ldGhvZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSU8sU0FBU0Esa0JBQVQsQ0FBNEJDLGlCQUE1QixFQUFvREMsWUFBcEQsRUFBNkU7QUFDbEZELEVBQUFBLGlCQUFpQixDQUFDRSx3QkFBYUMsWUFBZCxDQUFqQixHQUErQ0YsWUFBWSxDQUFDO0FBQzFERyxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLGVBQUlILFlBQWEsOEJBRHRCO0FBRUhJLE1BQUFBLEdBQUcsRUFBRTtBQUNIQyxRQUFBQSxVQUFVLEVBQUU7QUFDVkMsVUFBQUEsSUFBSSxFQUFFLFFBREk7QUFFVkMsVUFBQUEsUUFBUSxFQUFFO0FBRkE7QUFEVDtBQUZGLEtBRHFEO0FBVTFEQyxJQUFBQSxRQUFRLEVBQUUsS0FWZ0Q7QUFXMURDLElBQUFBLE1BQU0sRUFBRTtBQVhrRCxHQUFELENBQTNEO0FBYUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IE1FVEhPRF9OQU1FUywgQVBJIH0gZnJvbSAnLi4vdXRpbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGFkZEZpbmRpbmdzTWV0aG9kcyhzZWN1cml0eUFuYWx5dGljczogYW55LCBjcmVhdGVBY3Rpb246IGFueSk6IHZvaWQge1xuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuR0VUX0ZJTkRJTkdTXSA9IGNyZWF0ZUFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FQSS5HRVRfRklORElOR1N9P2RldGVjdG9yX2lkPTwlPWRldGVjdG9ySWQlPmAsXG4gICAgICByZXE6IHtcbiAgICAgICAgZGV0ZWN0b3JJZDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiBmYWxzZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBuZWVkQm9keTogZmFsc2UsXG4gICAgbWV0aG9kOiAnR0VUJyxcbiAgfSk7XG59XG4iXX0=