/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Environment;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;

public final class WelcomeDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private Form form;
    private MenuManager menuManager;
    ButtonGroup radioGroup;
    JButton createProject;
    JButton openProject;
    JButton manageResources;

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (!bl) {
            this.form.setCreateProject(this.createProject.isSelected());
            this.form.setOpenProject(this.openProject.isSelected());
            this.form.setManageResources(this.manageResources.isSelected());
        }
        return true;
    }

    public static WelcomeDialog getInstance(Frame frame, MenuManager menuManager) {
        return new WelcomeDialog(frame, menuManager);
    }

    private WelcomeDialog(Frame frame, MenuManager menuManager) {
        super(frame, Messages.getContextString("Text.welcomeToPod"), true);
        this.menuManager = menuManager;
        this.form = new Form();
    }

    protected void initControls() {
        this.createProject = new JButton(Messages.getString("Text.createProject"), IconManager.getIcon("menu24.new"));
        this.openProject = new JButton(Messages.getString("Text.openProject"), IconManager.getIcon("menu24.open"));
        this.manageResources = new JButton(Messages.getString("Text.manageResources"), IconManager.getIcon("view.resources"));
        HelpUtil.addDocHelp(this.createProject, "Creating_a_Project");
        HelpUtil.addDocHelp(this.manageResources, "Managing_your_resource_pool");
        this.createProject.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.createProject.setSelected(false);
                WelcomeDialog.this.openProject.setSelected(false);
                WelcomeDialog.this.manageResources.setSelected(false);
                ((JButton)actionEvent.getSource()).setSelected(true);
                WelcomeDialog.this.onOk();
            }
        };
        this.createProject.addActionListener(actionListener);
        this.openProject.addActionListener(actionListener);
        this.manageResources.addActionListener(actionListener);
        this.bind(true);
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, default, 3dlu, default", "p, 8dlu, p, 3dlu, p, 3dlu, p, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        defaultFormBuilder.append(Messages.getString("WelcomeDialog.WhatWouldYouLikeToDo") + "      ");
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.createProject);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.openProject);
        if (Environment.isAdministrator()) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.append(this.manageResources);
        }
        this.requestFocusInWindow();
        return defaultFormBuilder.getPanel();
    }

    public Form getForm() {
        return this.form;
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    @Override
    protected boolean hasOkAndCancelButtons() {
        return false;
    }

    public static class Form {
        boolean createProject = true;
        boolean openProject = false;
        boolean manageResources = false;

        public final boolean isCreateProject() {
            return this.createProject;
        }

        public final void setCreateProject(boolean bl) {
            this.createProject = bl;
        }

        public final boolean isManageResources() {
            return this.manageResources;
        }

        public final void setManageResources(boolean bl) {
            this.manageResources = bl;
        }

        public final boolean isOpenProject() {
            return this.openProject;
        }

        public final void setOpenProject(boolean bl) {
            this.openProject = bl;
        }
    }
}

