/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAliasPropCmd
implements CollApiCmds.CollectionApiCommand {
    public static final String PROPERTIES = "property";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public SetAliasPropCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String aliasName = message.getStr("name");
        ZkStateReader.AliasesManager aliasesManager = this.ccc.getZkStateReader().aliasesManager;
        aliasesManager.update();
        if (aliasesManager.getAliases().getCollectionAliasMap().get(aliasName) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Can't modify non-existent alias %s", aliasName));
        }
        LinkedHashMap properties = new LinkedHashMap((Map)message.get(PROPERTIES));
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if ("".equals(key.trim())) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "property keys must not be pure whitespace");
            }
            if (!key.equals(key.trim())) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "property keys should not begin or end with whitespace");
            }
            String value = (String)entry.getValue();
            if (!"".equals(value)) continue;
            entry.setValue(null);
        }
        aliasesManager.applyModificationAndExportToZk(aliases1 -> aliases1.cloneWithCollectionAliasProperties(aliasName, properties));
    }
}

