/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.SetCollectionPropertyPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class SetCollectionPropertyAPI {
    private static final String V2_SET_COLLECTION_PROPERTY_CMD = "set-collection-property";
    private final CollectionsHandler collectionsHandler;

    public SetCollectionPropertyAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="set-collection-property")
    public void setCollectionProperty(PayloadObj<SetCollectionPropertyPayload> obj) throws Exception {
        SetCollectionPropertyPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("propertyName", v1Params.remove("name"));
        if (v2Body.value != null) {
            v1Params.put("propertyValue", v2Body.value);
        }
        v1Params.put("action", CollectionParams.CollectionAction.COLLECTIONPROP.toLower());
        v1Params.put("name", obj.getRequest().getPathTemplateValues().get("collection"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

