/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.export.BoolFieldWriter;
import org.apache.solr.handler.export.DateFieldWriter;
import org.apache.solr.handler.export.DoubleComp;
import org.apache.solr.handler.export.DoubleFieldWriter;
import org.apache.solr.handler.export.DoubleValue;
import org.apache.solr.handler.export.DoubleValueSortDoc;
import org.apache.solr.handler.export.ExportBuffers;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.FloatComp;
import org.apache.solr.handler.export.FloatFieldWriter;
import org.apache.solr.handler.export.FloatValue;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.IntFieldWriter;
import org.apache.solr.handler.export.IntValue;
import org.apache.solr.handler.export.LongComp;
import org.apache.solr.handler.export.LongFieldWriter;
import org.apache.solr.handler.export.LongValue;
import org.apache.solr.handler.export.MultiFieldWriter;
import org.apache.solr.handler.export.QuadValueSortDoc;
import org.apache.solr.handler.export.SingleValueSortDoc;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortQueue;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.handler.export.StringFieldWriter;
import org.apache.solr.handler.export.StringValue;
import org.apache.solr.handler.export.TripleValueSortDoc;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatValueFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.LongValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableTextField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWriter
implements SolrCore.RawWriter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BATCH_SIZE_PARAM = "batchSize";
    public static final String QUEUE_SIZE_PARAM = "queueSize";
    public static final int DEFAULT_BATCH_SIZE = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 150000;
    private OutputStreamWriter respWriter;
    final SolrQueryRequest req;
    final SolrQueryResponse res;
    final StreamContext initialStreamContext;
    final SolrMetricsContext solrMetricsContext;
    final String metricsPath;
    final int batchSize;
    private int priorityQueueSize;
    StreamExpression streamExpression;
    StreamContext streamContext;
    FieldWriter[] fieldWriters;
    int totalHits = 0;
    FixedBitSet[] sets = null;
    PushWriter writer;
    private String wt;

    public ExportWriter(SolrQueryRequest req, SolrQueryResponse res, String wt, StreamContext initialStreamContext, SolrMetricsContext solrMetricsContext, String metricsPath) {
        this.req = req;
        this.res = res;
        this.wt = wt;
        this.initialStreamContext = initialStreamContext;
        this.solrMetricsContext = solrMetricsContext;
        this.metricsPath = metricsPath;
        this.priorityQueueSize = req.getParams().getInt(QUEUE_SIZE_PARAM, 150000);
        this.batchSize = 30000;
    }

    @Override
    public String getContentType() {
        if ("javabin".equals(this.wt)) {
            return "application/octet-stream";
        }
        return "json";
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.respWriter != null) {
            try {
                this.respWriter.flush();
                this.respWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void writeException(Exception e, PushWriter w, boolean logException) throws IOException {
        w.writeMap(mw -> mw.put((CharSequence)"responseHeader", Collections.singletonMap("status", 400)).put((CharSequence)"response", Map.of("numFound", 0, "docs", Collections.singletonList(Collections.singletonMap("EXCEPTION", e.getMessage())))));
        if (logException) {
            SolrException.log((Logger)log, (Throwable)e);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this._write(os);
    }

    private void _write(OutputStream os) throws IOException {
        QueryResponseWriter rw = this.req.getCore().getResponseWriters().get(this.wt);
        if (rw instanceof BinaryResponseWriter) {
            this.writer = new JavaBinCodec(os, null);
        } else {
            this.respWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            this.writer = JSONResponseWriter.getPushWriter(this.respWriter, this.req, this.res);
        }
        Exception exception = this.res.getException();
        if (exception != null) {
            if (!(exception instanceof IgnoreException)) {
                this.writeException(exception, this.writer, false);
            }
            return;
        }
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        SortSpec sortSpec = info.getResponseBuilder().getSortSpec();
        if (sortSpec == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        SolrIndexSearcher searcher = this.req.getSearcher();
        Sort sort = searcher.weightSort(sortSpec.getSort());
        if (sort == null) {
            this.writeException(new IOException(new SyntaxError("No sort criteria was provided.")), this.writer, true);
            return;
        }
        if (sort != null && sort.needsScores()) {
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        if (this.req.getContext().get("totalHits") != null) {
            this.totalHits = (Integer)this.req.getContext().get("totalHits");
            this.sets = (FixedBitSet[])this.req.getContext().get("export");
            if (this.sets == null) {
                this.writeException(new IOException(new SyntaxError("xport RankQuery is required for xsort: rq={!xport}")), this.writer, true);
                return;
            }
        }
        SolrParams params = this.req.getParams();
        String fl = params.get("fl");
        String[] fields = null;
        if (fl == null) {
            this.writeException(new IOException(new SyntaxError("export field list (fl) must be specified.")), this.writer, true);
            return;
        }
        fields = fl.split(",");
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
            if (!fields[i].equals("score")) continue;
            this.writeException(new IOException(new SyntaxError("Scoring is not currently supported with xsort.")), this.writer, true);
            return;
        }
        try {
            this.fieldWriters = this.getFieldWriters(fields, this.req.getSearcher());
        }
        catch (Exception e) {
            this.writeException(e, this.writer, true);
            return;
        }
        String expr = params.get("expr");
        if (expr != null) {
            StreamFactory streamFactory = this.initialStreamContext.getStreamFactory();
            streamFactory.withDefaultSort(params.get("sort"));
            try {
                StreamExpression expression = StreamExpressionParser.parse((String)expr);
                if (streamFactory.isEvaluator(expression)) {
                    this.streamExpression = new StreamExpression("tuple");
                    this.streamExpression.addParameter((StreamExpressionParameter)new StreamExpressionNamedParameter("return-value", (StreamExpressionParameter)expression));
                } else {
                    this.streamExpression = expression;
                }
            }
            catch (Exception e) {
                this.writeException(e, this.writer, true);
                return;
            }
            this.streamContext = new StreamContext();
            this.streamContext.setRequestParams(params);
            this.streamContext.setLocal(true);
            this.streamContext.workerID = 0;
            this.streamContext.numWorkers = 1;
            this.streamContext.setSolrClientCache(this.initialStreamContext.getSolrClientCache());
            this.streamContext.setModelCache(this.initialStreamContext.getModelCache());
            this.streamContext.setObjectCache(this.initialStreamContext.getObjectCache());
            this.streamContext.put("core", (Object)this.req.getCore().getName());
            this.streamContext.put("solr-core", (Object)this.req.getCore());
            this.streamContext.put("sort", (Object)params.get("sort"));
        }
        try {
            this.writer.writeMap(m -> {
                m.put((CharSequence)"responseHeader", Collections.singletonMap("status", 0));
                m.put((CharSequence)"response", mw -> {
                    mw.put((CharSequence)"numFound", this.totalHits);
                    mw.put((CharSequence)"docs", iw -> this.writeDocs(this.req, os, iw, sort));
                });
            });
        }
        catch (EOFException e) {
            log.info("Caught Eof likely caused by early client disconnect");
        }
        if (this.streamContext != null) {
            this.streamContext = null;
        }
    }

    private TupleStream createTupleStream() throws IOException {
        StreamFactory streamFactory = (StreamFactory)this.initialStreamContext.getStreamFactory().clone();
        streamFactory.withDefaultSort((String)this.streamContext.get((Object)"sort"));
        TupleStream tupleStream = streamFactory.constructStream(this.streamExpression);
        tupleStream.setStreamContext(this.streamContext);
        return tupleStream;
    }

    private void transferBatchToBufferForOutput(MergeIterator mergeIterator, ExportBuffers.Buffer destination) throws IOException {
        try {
            SortDoc sortDoc;
            int outDocsIndex = -1;
            for (int i = 0; i < this.batchSize && (sortDoc = mergeIterator.next()) != null; ++i) {
                destination.outDocs[++outDocsIndex].setValues(sortDoc);
            }
            destination.outDocsIndex = outDocsIndex;
        }
        catch (Throwable t) {
            log.error("transfer", t);
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw t;
        }
    }

    protected void writeDocs(SolrQueryRequest req, OutputStream os, IteratorWriter.ItemWriter writer, Sort sort) throws IOException {
        List leaves = req.getSearcher().getTopReaderContext().leaves();
        int queueSize = Math.min(this.batchSize, this.totalHits);
        ExportBuffers buffers = new ExportBuffers(this, leaves, req.getSearcher(), os, writer, sort, queueSize, this.totalHits, this.sets);
        if (this.streamExpression != null) {
            TupleStream tupleStream;
            this.streamContext.put("__eb__", (Object)buffers);
            try {
                tupleStream = this.createTupleStream();
                tupleStream.open();
            }
            catch (Exception e) {
                buffers.getWriter().add(ew -> Tuple.EXCEPTION((Throwable)e, (boolean)true).writeMap(ew));
                return;
            }
            buffers.run(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    Tuple t;
                    try {
                        t = tupleStream.read();
                    }
                    catch (Exception e) {
                        buffers.getWriter().add(ew -> Tuple.EXCEPTION((Throwable)e, (boolean)true).writeMap(ew));
                        break;
                    }
                    if (t == null || t.EOF && !t.EXCEPTION) break;
                    buffers.getWriter().add(ew -> t.writeMap(ew));
                    if (!t.EXCEPTION || !t.EOF) continue;
                    break;
                }
                return true;
            });
            tupleStream.close();
        } else {
            buffers.run(() -> {
                log.debug("--- writer init exchanging from empty");
                buffers.exchangeBuffers();
                ExportBuffers.Buffer buffer = buffers.getOutputBuffer();
                log.debug("--- writer init got {}", (Object)buffer);
                while (buffer.outDocsIndex != -2) {
                    if (Thread.currentThread().isInterrupted()) {
                        log.debug("--- writer interrupted");
                        break;
                    }
                    for (int i = 0; i <= buffer.outDocsIndex; ++i) {
                        SortDoc currentDoc = buffer.outDocs[i];
                        writer.add(ew -> this.writeDoc(currentDoc, leaves, ew, this.fieldWriters));
                    }
                    long startExchangeBuffers = System.nanoTime();
                    buffers.exchangeBuffers();
                    long endExchangeBuffers = System.nanoTime();
                    if (log.isDebugEnabled()) {
                        log.debug("Waited for reader thread {}:", (Object)Long.toString((endExchangeBuffers - startExchangeBuffers) / 1000000L));
                    }
                    buffer = buffers.getOutputBuffer();
                }
                return true;
            });
        }
    }

    void fillOutDocs(MergeIterator mergeIterator, ExportBuffers.Buffer buffer) throws IOException {
        this.transferBatchToBufferForOutput(mergeIterator, buffer);
    }

    void writeDoc(SortDoc sortDoc, List<LeafReaderContext> leaves, MapWriter.EntryWriter ew, FieldWriter[] writers) throws IOException {
        int ord = sortDoc.ord;
        LeafReaderContext context = leaves.get(ord);
        int fieldIndex = 0;
        for (FieldWriter fieldWriter : writers) {
            if (!fieldWriter.write(sortDoc, context, ew, fieldIndex)) continue;
            ++fieldIndex;
        }
    }

    public FieldWriter[] getFieldWriters(String[] fields, SolrIndexSearcher searcher) throws IOException {
        IndexSchema schema = searcher.getSchema();
        FieldWriter[] writers = new FieldWriter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            SchemaField schemaField = null;
            try {
                schemaField = schema.getField(field);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (!schemaField.hasDocValues()) {
                throw new IOException(schemaField + " must have DocValues to use this feature.");
            }
            boolean multiValued = schemaField.multiValued();
            FieldType fieldType = schemaField.getType();
            if (fieldType instanceof SortableTextField && !schemaField.useDocValuesAsStored()) {
                throw new IOException(schemaField + " Must have useDocValuesAsStored='true' to be used with export writer");
            }
            if (fieldType instanceof IntValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new IntFieldWriter(field);
                continue;
            }
            if (fieldType instanceof LongValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new LongFieldWriter(field);
                continue;
            }
            if (fieldType instanceof FloatValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new FloatFieldWriter(field);
                continue;
            }
            if (fieldType instanceof DoubleValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new DoubleFieldWriter(field);
                continue;
            }
            if (fieldType instanceof StrField || fieldType instanceof SortableTextField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new StringFieldWriter(field, fieldType);
                continue;
            }
            if (fieldType instanceof DateValueFieldType) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, false);
                    continue;
                }
                writers[i] = new DateFieldWriter(field);
                continue;
            }
            if (fieldType instanceof BoolField) {
                if (multiValued) {
                    writers[i] = new MultiFieldWriter(field, fieldType, schemaField, true);
                    continue;
                }
                writers[i] = new BoolFieldWriter(field, fieldType);
                continue;
            }
            throw new IOException("Export fields must be one of the following types: int,float,long,double,string,date,boolean,SortableText");
        }
        return writers;
    }

    SortDoc getSortDoc(SolrIndexSearcher searcher, SortField[] sortFields) throws IOException {
        SortValue[] sortValues = new SortValue[sortFields.length];
        IndexSchema schema = searcher.getSchema();
        for (int i = 0; i < sortFields.length; ++i) {
            SortedDocValues vals;
            LeafReader reader;
            SortField sf = sortFields[i];
            String field = sf.getField();
            boolean reverse = sf.getReverse();
            SchemaField schemaField = schema.getField(field);
            FieldType ft = schemaField.getType();
            if (!schemaField.hasDocValues()) {
                throw new IOException(field + " must have DocValues to use this feature.");
            }
            if (ft instanceof SortableTextField && !schemaField.useDocValuesAsStored()) {
                throw new IOException(schemaField + " Must have useDocValuesAsStored='true' to be used with export writer");
            }
            if (ft instanceof IntValueFieldType) {
                if (reverse) {
                    sortValues[i] = new IntValue(field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new IntValue(field, new IntComp.IntAsc());
                continue;
            }
            if (ft instanceof FloatValueFieldType) {
                if (reverse) {
                    sortValues[i] = new FloatValue(field, new FloatComp.FloatDesc());
                    continue;
                }
                sortValues[i] = new FloatValue(field, new FloatComp.FloatAsc());
                continue;
            }
            if (ft instanceof DoubleValueFieldType) {
                if (reverse) {
                    sortValues[i] = new DoubleValue(field, new DoubleComp.DoubleDesc());
                    continue;
                }
                sortValues[i] = new DoubleValue(field, new DoubleComp.DoubleAsc());
                continue;
            }
            if (ft instanceof LongValueFieldType) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongComp.LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongComp.LongAsc());
                continue;
            }
            if (ft instanceof StrField || ft instanceof SortableTextField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntComp.IntAsc());
                continue;
            }
            if (ft instanceof DateValueFieldType) {
                if (reverse) {
                    sortValues[i] = new LongValue(field, new LongComp.LongDesc());
                    continue;
                }
                sortValues[i] = new LongValue(field, new LongComp.LongAsc());
                continue;
            }
            if (ft instanceof BoolField) {
                reader = searcher.getSlowAtomicReader();
                vals = reader.getSortedDocValues(field);
                if (reverse) {
                    sortValues[i] = new StringValue(vals, field, new IntComp.IntDesc());
                    continue;
                }
                sortValues[i] = new StringValue(vals, field, new IntComp.IntAsc());
                continue;
            }
            throw new IOException("Sort fields must be one of the following types: int,float,long,double,string,date,boolean,SortableText");
        }
        if (sortValues.length == 1) {
            return new SingleValueSortDoc(sortValues[0]);
        }
        if (sortValues.length == 2) {
            return new DoubleValueSortDoc(sortValues[0], sortValues[1]);
        }
        if (sortValues.length == 3) {
            return new TripleValueSortDoc(sortValues[0], sortValues[1], sortValues[2]);
        }
        if (sortValues.length == 4) {
            return new QuadValueSortDoc(sortValues[0], sortValues[1], sortValues[2], sortValues[3]);
        }
        return new SortDoc(sortValues);
    }

    public MergeIterator getMergeIterator(List<LeafReaderContext> leaves, FixedBitSet[] bits, SortDoc sortDoc) throws IOException {
        long totalDocs = 0L;
        for (int i = 0; i < leaves.size(); ++i) {
            totalDocs += (long)leaves.get(i).reader().maxDoc();
        }
        this.priorityQueueSize = Math.min(this.priorityQueueSize, (int)((double)this.totalHits * 1.2));
        if (log.isDebugEnabled()) {
            log.debug("Total priority queue size {}:", (Object)this.priorityQueueSize);
        }
        int[] sizes = new int[leaves.size()];
        int combineQueueSize = 0;
        for (int i = 0; i < leaves.size(); ++i) {
            long maxDoc = leaves.get(i).reader().maxDoc();
            int sortQueueSize = Math.min((int)((double)maxDoc / (double)totalDocs * (double)this.priorityQueueSize), this.batchSize);
            if (sortQueueSize < 10) {
                sortQueueSize = 10;
            }
            if (log.isDebugEnabled()) {
                log.debug("Segment priority queue size {}:", (Object)sortQueueSize);
            }
            sizes[i] = sortQueueSize;
            combineQueueSize += sortQueueSize;
        }
        if (log.isDebugEnabled()) {
            log.debug("Combined priority queue size {}:", (Object)combineQueueSize);
        }
        SegmentIterator[] segmentIterators = new SegmentIterator[leaves.size()];
        for (int i = 0; i < segmentIterators.length; ++i) {
            SortQueue sortQueue = new SortQueue(sizes[i], sortDoc.copy());
            segmentIterators[i] = new SegmentIterator(bits[i], leaves.get(i), sortQueue, sortDoc.copy());
        }
        return new MergeIterator(segmentIterators, sortDoc);
    }

    public static class IgnoreException
    extends IOException {
        @Override
        public void printStackTrace(PrintWriter pw) {
            pw.print("Early Client Disconnect");
        }

        @Override
        public String getMessage() {
            return "Early Client Disconnect";
        }
    }

    private static class SegmentIterator {
        private final FixedBitSet bits;
        private final SortQueue queue;
        private final SortDoc sortDoc;
        private final LeafReaderContext context;
        private final SortDoc[] outDocs;
        private SortDoc nextDoc;
        private int index;

        public SegmentIterator(FixedBitSet bits, LeafReaderContext context, SortQueue sortQueue, SortDoc sortDoc) throws IOException {
            this.bits = bits;
            this.queue = sortQueue;
            this.sortDoc = sortDoc;
            this.nextDoc = sortDoc.copy();
            this.context = context;
            this.outDocs = new SortDoc[sortQueue.maxSize];
            this.topDocs();
        }

        public SortDoc next() throws IOException {
            SortDoc _sortDoc = null;
            if (this.index > -1) {
                _sortDoc = this.outDocs[this.index--];
            } else {
                this.topDocs();
                if (this.index > -1) {
                    _sortDoc = this.outDocs[this.index--];
                }
            }
            if (_sortDoc != null) {
                this.bits.clear(_sortDoc.docId);
                _sortDoc.setGlobalValues(this.nextDoc);
                this.nextDoc.setValues(_sortDoc);
                _sortDoc.reset();
            } else {
                this.nextDoc = null;
            }
            return this.nextDoc;
        }

        private void topDocs() throws IOException {
            try {
                SortDoc _sortDoc;
                int docId;
                this.queue.reset();
                SortDoc top = this.queue.top();
                this.sortDoc.setNextReader(this.context);
                BitSetIterator it = new BitSetIterator((BitSet)this.bits, 0L);
                while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                    this.sortDoc.setValues(docId);
                    if (!top.lessThan(this.sortDoc) && top.docId != -1) continue;
                    top.setValues(this.sortDoc);
                    top = this.queue.updateTop();
                }
                this.index = -1;
                while ((_sortDoc = this.queue.pop()) != null) {
                    if (_sortDoc.docId <= -1) continue;
                    this.outDocs[++this.index] = _sortDoc;
                }
            }
            catch (Exception e) {
                log.error("Segment Iterator Error:", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    static class MergeIterator {
        private TreeSet<SortDoc> set = new TreeSet();
        private SegmentIterator[] segmentIterators;
        private SortDoc outDoc;

        public MergeIterator(SegmentIterator[] segmentIterators, SortDoc proto) throws IOException {
            this.outDoc = proto.copy();
            this.segmentIterators = segmentIterators;
            for (int i = 0; i < segmentIterators.length; ++i) {
                try {
                    SortDoc sortDoc = segmentIterators[i].next();
                    if (sortDoc == null) continue;
                    this.set.add(sortDoc);
                    continue;
                }
                catch (IOException e) {
                    log.error("Error in MergeIterator: ", (Throwable)e);
                    throw e;
                }
            }
        }

        public SortDoc next() throws IOException {
            SortDoc sortDoc = this.set.pollLast();
            if (sortDoc == null) {
                return null;
            }
            this.outDoc.setValues(sortDoc);
            SortDoc nextDoc = this.segmentIterators[sortDoc.ord].next();
            if (nextDoc != null) {
                this.set.add(nextDoc);
            }
            return this.outDoc;
        }
    }
}

