/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.FieldValueMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public final class TruncateFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final String MAX_LENGTH_PARAM = "maxLength";
    private int maxLength = 0;

    @Override
    public void init(NamedList<?> args) {
        Object lengthParam = args.remove(MAX_LENGTH_PARAM);
        if (null == lengthParam) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: maxLength");
        }
        if (!(lengthParam instanceof Number)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param maxLengthmust be a number; found: \"" + lengthParam.toString());
        }
        this.maxLength = ((Number)lengthParam).intValue();
        if (this.maxLength < 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param maxLengthmust be >= 0; found: " + this.maxLength);
        }
        super.init(args);
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return FieldValueMutatingUpdateProcessor.valueMutator(this.getSelector(), next, src -> {
            CharSequence s;
            if (src instanceof CharSequence && this.maxLength < (s = (CharSequence)src).length()) {
                return s.subSequence(0, this.maxLength);
            }
            return src;
        });
    }
}

