/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.util.configuration.SSLCredentialProvider;
import org.apache.solr.util.configuration.providers.EnvSSLCredentialProvider;
import org.apache.solr.util.configuration.providers.SysPropSSLCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCredentialProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_PROVIDER_CHAIN = "env;sysprop";
    public static final String PROVIDER_CHAIN_KEY = "solr.ssl.credential.provider.chain";
    private static final Map<String, Class<? extends SSLCredentialProvider>> defaultProviders = ImmutableMap.of((Object)"env", EnvSSLCredentialProvider.class, (Object)"sysprop", SysPropSSLCredentialProvider.class);
    private String providerChain;

    public SSLCredentialProviderFactory() {
        this.providerChain = System.getProperty(PROVIDER_CHAIN_KEY, DEFAULT_PROVIDER_CHAIN);
    }

    public SSLCredentialProviderFactory(String providerChain) {
        this.providerChain = providerChain;
    }

    public List<SSLCredentialProvider> getProviders() {
        ArrayList<SSLCredentialProvider> providers = new ArrayList<SSLCredentialProvider>();
        if (log.isDebugEnabled()) {
            log.debug(String.format(Locale.ROOT, "Processing SSL Credential Provider chain: %s", this.providerChain));
        }
        String classPrefix = "class://";
        for (String provider : this.providerChain.split(";")) {
            if (defaultProviders.containsKey(provider)) {
                providers.add(this.getDefaultProvider(defaultProviders.get(provider)));
                continue;
            }
            if (provider.startsWith(classPrefix)) {
                providers.add(this.getProviderByClassName(provider.substring(classPrefix.length())));
                continue;
            }
            throw new RuntimeException("Unable to parse credential provider: " + provider);
        }
        return providers;
    }

    private SSLCredentialProvider getProviderByClassName(String clazzName) {
        try {
            return Class.forName(clazzName).asSubclass(SSLCredentialProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format(Locale.ROOT, "Could not instantiate %s credential provider", clazzName);
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
    }

    private SSLCredentialProvider getDefaultProvider(Class<? extends SSLCredentialProvider> aClass) {
        try {
            return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format(Locale.ROOT, "Could not instantiate %s credential provider", aClass.getName());
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
    }
}

