/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.nonblocking.ServerTCPNonBlockingTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpNoDelayTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ServerTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.proxy.TimingProxyClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.timing.TimingClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.timing.TimingServerTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.ClientUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.ServerUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.timing.TimingClientUdpTransportHandler;
import de.rub.nds.tlsattacker.transport.udp.timing.TimingServerUdpTransportHandler;

public class TransportHandlerFactory {
    public static TransportHandler createTransportHandler(Connection con) {
        ConnectionEndType localConEndType = con.getLocalConnectionEndType();
        Long timeout = new Long(con.getTimeout().intValue());
        switch (con.getTransportHandlerType()) {
            case TCP: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientTcpTransportHandler((long)timeout, con.getIp(), con.getPort());
                }
                return new ServerTcpTransportHandler((long)timeout, con.getPort());
            }
            case EAP_TLS: {
                throw new UnsupportedOperationException("EAP_TLS is currently not supported");
            }
            case UDP: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientUdpTransportHandler((long)timeout, con.getIp(), con.getPort());
                }
                return new ServerUdpTransportHandler((long)timeout, con.getPort());
            }
            case NON_BLOCKING_TCP: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    throw new UnsupportedOperationException("NON_BLOCKING_TCP-Transporthandler is not supported");
                }
                return new ServerTCPNonBlockingTransportHandler((long)timeout, con.getPort());
            }
            case STREAM: {
                throw new UnsupportedOperationException("STREAM TransportHandler can only be created manually");
            }
            case TCP_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingClientTcpTransportHandler((long)timeout, con.getIp(), con.getPort());
                }
                return new TimingServerTcpTransportHandler((long)timeout, con.getPort());
            }
            case UDP_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingClientUdpTransportHandler((long)timeout, con.getIp(), con.getPort());
                }
                return new TimingServerUdpTransportHandler((long)timeout, con.getPort());
            }
            case TCP_PROXY_TIMING: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new TimingProxyClientTcpTransportHandler(con);
                }
                throw new UnsupportedOperationException("TCP_PROXY_TIMING for server sockets is currently not supported");
            }
            case TCP_NO_DELAY: {
                if (localConEndType == ConnectionEndType.CLIENT) {
                    return new ClientTcpNoDelayTransportHandler((long)timeout, con.getIp(), con.getPort());
                }
                throw new UnsupportedOperationException("This transport handler type is only supported in client mode");
            }
        }
        throw new UnsupportedOperationException("This transport handler type is not supported");
    }

    private TransportHandlerFactory() {
    }
}

