/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.RSAClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskRsaClientKeyExchangeParser
extends RSAClientKeyExchangeParser<PskRsaClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskRsaClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(PskRsaClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKRSAClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
        super.parseRsaParams(msg);
    }

    @Override
    protected PskRsaClientKeyExchangeMessage createHandshakeMessage() {
        return new PskRsaClientKeyExchangeMessage();
    }

    private void parsePskIdentityLength(PskRsaClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PSK-IdentityLength: " + msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskRsaClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("PSK-Identity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentity().getValue())));
    }
}

